/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.References;

public class EntityHealthFix
extends DataFix {
    private static final Set<String> ENTITIES = Sets.newHashSet((Object[])new String[]{"ArmorStand", "Bat", "Blaze", "CaveSpider", "Chicken", "Cow", "Creeper", "EnderDragon", "Enderman", "Endermite", "EntityHorse", "Ghast", "Giant", "Guardian", "LavaSlime", "MushroomCow", "Ozelot", "Pig", "PigZombie", "Rabbit", "Sheep", "Shulker", "Silverfish", "Skeleton", "Slime", "SnowMan", "Spider", "Squid", "Villager", "VillagerGolem", "Witch", "WitherBoss", "Wolf", "Zombie"});

    public EntityHealthFix(Schema schema, boolean bl) {
        super(schema, bl);
    }

    /*
     * WARNING - void declaration
     */
    public Dynamic<?> fixTag(Dynamic<?> dynamic) {
        void h;
        Optional optional = dynamic.get("HealF").asNumber().result();
        Optional optional2 = dynamic.get("Health").asNumber().result();
        if (optional.isPresent()) {
            float f = ((Number)optional.get()).floatValue();
            dynamic = dynamic.remove("HealF");
        } else if (optional2.isPresent()) {
            float g = ((Number)optional2.get()).floatValue();
        } else {
            return dynamic;
        }
        return dynamic.set("Health", dynamic.createFloat((float)h));
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityHealthFix", this.getInputSchema().getType(References.ENTITY), typed -> typed.update(DSL.remainderFinder(), this::fixTag));
    }
}

