/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.datafix.fixes.References;

public class FeatureFlagRemoveFix
extends DataFix {
    private final String name;
    private final Set<String> flagsToRemove;

    public FeatureFlagRemoveFix(Schema outputSchema, String name, Set<String> featureToggleIds) {
        super(outputSchema, false);
        this.name = name;
        this.flagsToRemove = featureToggleIds;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name, this.getInputSchema().getType(References.LEVEL), typed -> typed.update(DSL.remainderFinder(), this::fixTag));
    }

    private <T> Dynamic<T> fixTag(Dynamic<T> dynamic) {
        List list = dynamic.get("removed_features").asStream().collect(Collectors.toCollection(ArrayList::new));
        Dynamic<T> dynamic2 = dynamic.update("enabled_features", enabledFeatures -> (Dynamic)((Object)((Object)DataFixUtils.orElse(enabledFeatures.asStreamOpt().result().map(stream -> stream.filter(enabledFeature -> {
            Optional optional = enabledFeature.asString().result();
            if (optional.isEmpty()) {
                return true;
            }
            boolean bl = this.flagsToRemove.contains(optional.get());
            if (bl) {
                list.add(dynamic.createString((String)optional.get()));
            }
            return !bl;
        })).map(arg_0 -> ((Dynamic)dynamic).createList(arg_0)), (Object)enabledFeatures))));
        if (!list.isEmpty()) {
            dynamic2 = dynamic2.set("removed_features", dynamic.createList(list.stream()));
        }
        return dynamic2;
    }
}

