/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.References;

public class RenameEnchantmentsFix
extends DataFix {
    final String name;
    final Map<String, String> renames;

    public RenameEnchantmentsFix(Schema outputSchema, String name, Map<String, String> oldToNewIds) {
        super(outputSchema, false);
        this.name = name;
        this.renames = oldToNewIds;
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticFinder = type.findField("tag");
        return this.fixTypeEverywhereTyped(this.name, type, typed2 -> typed2.updateTyped(opticFinder, typed -> typed.update(DSL.remainderFinder(), this::fixTag)));
    }

    private Dynamic<?> fixTag(Dynamic<?> data) {
        data = this.fixEnchantmentList(data, "Enchantments");
        data = this.fixEnchantmentList(data, "StoredEnchantments");
        return data;
    }

    private Dynamic<?> fixEnchantmentList(Dynamic<?> data, String key) {
        return data.update(key, dynamic -> (Dynamic)((Object)((Object)dynamic.asStreamOpt().map(stream -> stream.map(dynamic -> dynamic.update("id", dynamic2 -> (Dynamic)((Object)((Object)((Object)((Object)((Object)dynamic2.asString().map(oldId -> dynamic.createString(this.renames.getOrDefault(oldId, (String)oldId))).mapOrElse(Function.identity(), error -> dynamic2))))))))).map(arg_0 -> ((Dynamic)((Object)dynamic)).createList(arg_0)).mapOrElse(Function.identity(), error -> dynamic))));
    }
}

