/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.StringRepresentable;

public enum EquipmentSlot implements StringRepresentable
{
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head"),
    BODY(Type.BODY, 0, 6, "body");

    public static final StringRepresentable.EnumCodec<EquipmentSlot> CODEC;
    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;

    private EquipmentSlot(Type type, int entityId, int armorStandId, String name) {
        this.type = type;
        this.index = entityId;
        this.filterFlag = armorStandId;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int offset) {
        return offset + this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Type.ARMOR;
    }

    @Override
    @Override
    public String getSerializedName() {
        return this.name;
    }

    public static EquipmentSlot byName(String name) {
        EquipmentSlot equipmentSlot = CODEC.byName(name);
        if (equipmentSlot != null) {
            return equipmentSlot;
        }
        throw new IllegalArgumentException("Invalid slot '" + name + "'");
    }

    public static EquipmentSlot byTypeAndIndex(Type type, int index) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.getType() != type || equipmentSlot.getIndex() != index) continue;
            return equipmentSlot;
        }
        throw new IllegalArgumentException("Invalid slot '" + String.valueOf((Object)type) + "': " + index);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EquipmentSlot::values);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BODY;

    }
}

