/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BabyFollowAdult {
    public static OneShot<AgeableMob> create(UniformInt executionRange, float speed) {
        return BabyFollowAdult.create(executionRange, entityliving -> Float.valueOf(speed));
    }

    public static OneShot<AgeableMob> create(UniformInt executionRange, Function<LivingEntity, Float> speed) {
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.NEAREST_VISIBLE_ADULT), behaviorbuilder_b.registered(MemoryModuleType.LOOK_TARGET), behaviorbuilder_b.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityageable, i) -> {
            if (!entityageable.isBaby()) {
                return false;
            }
            LivingEntity entityageable1 = (AgeableMob)behaviorbuilder_b.get(memoryaccessor);
            if (entityageable.closerThan(entityageable1, executionRange.getMaxValue() + 1) && !entityageable.closerThan(entityageable1, executionRange.getMinValue())) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityageable, entityageable1, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                if (event.isCancelled()) {
                    return false;
                }
                if (event.getTarget() == null) {
                    memoryaccessor.erase();
                    return true;
                }
                entityageable1 = ((CraftLivingEntity)event.getTarget()).getHandle();
                WalkTarget memorytarget = new WalkTarget(new EntityTracker(entityageable1, false), ((Float)speed.apply(entityageable)).floatValue(), executionRange.getMinValue() - 1);
                memoryaccessor1.set(new EntityTracker(entityageable1, true));
                memoryaccessor2.set(memorytarget);
                return true;
            }
            return false;
        }));
    }
}

