/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityInteractEvent;

public class InteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 20;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableobject = new MutableObject(null);
        MutableInt mutableint = new MutableInt(0);
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.PATH), behaviorbuilder_b.registered(MemoryModuleType.DOORS_TO_CLOSE), behaviorbuilder_b.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityliving, i) -> {
            Path pathentity = (Path)behaviorbuilder_b.get(memoryaccessor);
            Optional<Set<GlobalPos>> optional = behaviorbuilder_b.tryGet(memoryaccessor1);
            if (!pathentity.notStarted() && !pathentity.isDone()) {
                DoorBlock blockdoor1;
                BlockPos blockposition1;
                BlockState iblockdata1;
                if (Objects.equals(mutableobject.getValue(), pathentity.getNextNode())) {
                    mutableint.setValue(20);
                } else if (mutableint.decrementAndGet() > 0) {
                    return false;
                }
                mutableobject.setValue((Object)pathentity.getNextNode());
                Node pathpoint = pathentity.getPreviousNode();
                Node pathpoint1 = pathentity.getNextNode();
                BlockPos blockposition = pathpoint.asBlockPos();
                BlockState iblockdata = worldserver.getBlockState(blockposition);
                if (iblockdata.is(BlockTags.WOODEN_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock) && !DoorBlock.requiresRedstone(entityliving.level(), iblockdata, blockposition)) {
                    DoorBlock blockdoor = (DoorBlock)iblockdata.getBlock();
                    if (!blockdoor.isOpen(iblockdata)) {
                        EntityInteractEvent event = new EntityInteractEvent((Entity)entityliving.getBukkitEntity(), (Block)CraftBlock.at(entityliving.level(), blockposition));
                        entityliving.level().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return false;
                        }
                        blockdoor.setOpen(entityliving, worldserver, iblockdata, blockposition, true);
                    }
                    optional = InteractWithDoor.rememberDoorToClose(memoryaccessor1, optional, worldserver, blockposition);
                }
                if ((iblockdata1 = worldserver.getBlockState(blockposition1 = pathpoint1.asBlockPos())).is(BlockTags.WOODEN_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock) && !DoorBlock.requiresRedstone(entityliving.level(), iblockdata, blockposition1) && !(blockdoor1 = (DoorBlock)iblockdata1.getBlock()).isOpen(iblockdata1)) {
                    EntityInteractEvent event = new EntityInteractEvent((Entity)entityliving.getBukkitEntity(), (Block)CraftBlock.at(entityliving.level(), blockposition1));
                    entityliving.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    blockdoor1.setOpen(entityliving, worldserver, iblockdata1, blockposition1, true);
                    optional = InteractWithDoor.rememberDoorToClose(memoryaccessor1, optional, worldserver, blockposition1);
                }
                optional.ifPresent(set -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(worldserver, entityliving, pathpoint, pathpoint1, set, behaviorbuilder_b.tryGet(memoryaccessor2)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel world, LivingEntity entity, @Nullable Node lastNode, @Nullable Node currentNode, Set<GlobalPos> doors, Optional<List<LivingEntity>> otherMobs) {
        Iterator<GlobalPos> iterator = doors.iterator();
        while (iterator.hasNext()) {
            GlobalPos globalpos = iterator.next();
            BlockPos blockposition = globalpos.pos();
            if (lastNode != null && lastNode.asBlockPos().equals(blockposition) || currentNode != null && currentNode.asBlockPos().equals(blockposition)) continue;
            if (InteractWithDoor.isDoorTooFarAway(world, entity, globalpos)) {
                iterator.remove();
                continue;
            }
            BlockState iblockdata = world.getBlockState(blockposition);
            if (!iblockdata.is(BlockTags.WOODEN_DOORS, blockbase_blockdata -> blockbase_blockdata.getBlock() instanceof DoorBlock) || DoorBlock.requiresRedstone(entity.level(), iblockdata, blockposition)) {
                iterator.remove();
                continue;
            }
            DoorBlock blockdoor = (DoorBlock)iblockdata.getBlock();
            if (!blockdoor.isOpen(iblockdata)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.areOtherMobsComingThroughDoor(entity, blockposition, otherMobs)) {
                iterator.remove();
                continue;
            }
            blockdoor.setOpen(entity, world, iblockdata, blockposition, false);
            iterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos pos, Optional<List<LivingEntity>> otherMobs) {
        return otherMobs.isEmpty() ? false : otherMobs.get().stream().filter(entityliving1 -> entityliving1.getType() == entity.getType()).filter(entityliving1 -> pos.closerToCenterThan(entityliving1.position(), 2.0)).anyMatch(entityliving1 -> InteractWithDoor.isMobComingThroughDoor(entityliving1.getBrain(), pos));
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos pos) {
        if (!brain.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path pathentity = brain.getMemory(MemoryModuleType.PATH).get();
        if (pathentity.isDone()) {
            return false;
        }
        Node pathpoint = pathentity.getPreviousNode();
        if (pathpoint == null) {
            return false;
        }
        Node pathpoint1 = pathentity.getNextNode();
        return pos.equals(pathpoint.asBlockPos()) || pos.equals(pathpoint1.asBlockPos());
    }

    private static boolean isDoorTooFarAway(ServerLevel world, LivingEntity entity, GlobalPos doorPos) {
        return doorPos.dimension() != world.dimension() || !doorPos.pos().closerToCenterThan(entity.position(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> queryResult, Optional<Set<GlobalPos>> doors, ServerLevel world, BlockPos pos) {
        GlobalPos globalpos = GlobalPos.of(world.dimension(), pos);
        return Optional.of(doors.map(set -> {
            set.add(globalpos);
            return set;
        }).orElseGet(() -> {
            HashSet set = Sets.newHashSet((Object[])new GlobalPos[]{globalpos});
            queryResult.set(set);
            return set;
        }));
    }
}

