/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SetClosestHomeAsWalkTarget {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private static final int OK_DISTANCE_SQR = 4;

    public static BehaviorControl<PathfinderMob> create(float speed) {
        Long2LongOpenHashMap long2LongMap = new Long2LongOpenHashMap();
        MutableLong mutableLong = new MutableLong(0L);
        return BehaviorBuilder.create(arg_0 -> SetClosestHomeAsWalkTarget.lambda$create$6(mutableLong, (Long2LongMap)long2LongMap, speed, arg_0));
    }

    private static /* synthetic */ App lambda$create$6(MutableLong context, Long2LongMap long2LongMap, float f, BehaviorBuilder.Instance instance) {
        return instance.group(instance.absent(MemoryModuleType.WALK_TARGET), instance.absent(MemoryModuleType.HOME)).apply((Applicative)instance, (walkTarget, home) -> (world, entity, time) -> {
            if (world.getGameTime() - context.getValue() < 20L) {
                return false;
            }
            PoiManager poiManager = world.getPoiManager();
            Optional<BlockPos> optional = poiManager.findClosest(poiType -> poiType.is(PoiTypes.HOME), entity.blockPosition(), 48, PoiManager.Occupancy.ANY);
            if (optional.isEmpty() || optional.get().distSqr(entity.blockPosition()) <= 4.0) {
                return false;
            }
            MutableInt mutableInt = new MutableInt(0);
            context.setValue(world.getGameTime() + (long)world.getRandom().nextInt(20));
            Predicate<BlockPos> predicate = pos -> {
                long l = pos.asLong();
                if (long2LongMap.containsKey(l)) {
                    return false;
                }
                if (mutableInt.incrementAndGet() >= 5) {
                    return false;
                }
                long2LongMap.put(l, context.getValue() + 40L);
                return true;
            };
            Set<Pair<Holder<PoiType>, BlockPos>> set = poiManager.findAllWithType(poiType -> poiType.is(PoiTypes.HOME), predicate, entity.blockPosition(), 48, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
            Path path = AcquirePoi.findPathToPois(entity, set);
            if (path != null && path.canReach()) {
                BlockPos blockPos = path.getTarget();
                Optional<Holder<PoiType>> optional2 = poiManager.getType(blockPos);
                if (optional2.isPresent()) {
                    walkTarget.set(new WalkTarget(blockPos, f, 1));
                    DebugPackets.sendPoiTicketCountPacket(world, blockPos);
                }
            } else if (mutableInt.getValue() < 5) {
                long2LongMap.long2LongEntrySet().removeIf(entry -> entry.getLongValue() < context.getValue());
            }
            return true;
        });
    }
}

