/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.GameRules;

public class StartCelebratingIfTargetDead {
    public static BehaviorControl<LivingEntity> create(int celebrationDuration, BiPredicate<LivingEntity, LivingEntity> predicate) {
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.ATTACK_TARGET), context.registered(MemoryModuleType.ANGRY_AT), context.absent(MemoryModuleType.CELEBRATE_LOCATION), context.registered(MemoryModuleType.DANCING)).apply((Applicative)context, (attackTarget, angryAt, celebrateLocation, dancing) -> (world, entity, time) -> {
            LivingEntity livingEntity = (LivingEntity)context.get(attackTarget);
            if (!livingEntity.isDeadOrDying()) {
                return false;
            }
            if (predicate.test(entity, livingEntity)) {
                dancing.setWithExpiry(true, celebrationDuration);
            }
            celebrateLocation.setWithExpiry(livingEntity.blockPosition(), celebrationDuration);
            if (livingEntity.getType() != EntityType.PLAYER || world.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
                attackTarget.erase();
                angryAt.erase();
            }
            return true;
        }));
    }
}

