/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.util.player.NearbyPlayers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PlayerSensor
extends Sensor<LivingEntity> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    @Override
    protected void doTick(ServerLevel world, LivingEntity entity) {
        NearbyPlayers nearbyPlayers = world.chunkSource.chunkMap.getNearbyPlayers();
        Vec3 entityPos = entity.position();
        ReferenceList<ServerPlayer> nearby = nearbyPlayers.getPlayersByChunk(entity.chunkPosition().x, entity.chunkPosition().z, NearbyPlayers.NearbyMapType.GENERAL_REALLY_SMALL);
        ArrayList<Player> players = new ArrayList<Player>(nearby == null ? 0 : nearby.size());
        if (nearby != null) {
            Object[] rawData = nearby.getRawData();
            int len = nearby.size();
            for (int index = 0; index < len; ++index) {
                ServerPlayer player = (ServerPlayer)rawData[index];
                if (player.isSpectator() || player.distanceToSqr(entityPos.x, entityPos.y, entityPos.z) >= 256.0) continue;
                players.add(player);
            }
        }
        players.sort(Comparator.comparingDouble(entity::distanceToSqr));
        Brain<?> brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_PLAYERS, players);
        Player firstTargetable = null;
        Player firstAttackable = null;
        for (Player player : players) {
            if (firstTargetable == null && Sensor.isEntityTargetable(entity, player)) {
                firstTargetable = player;
            }
            if (firstAttackable == null && Sensor.isEntityAttackable(entity, player)) {
                firstAttackable = player;
            }
            if (firstAttackable == null || firstTargetable == null) continue;
            break;
        }
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, firstTargetable);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, Optional.ofNullable(firstAttackable));
    }
}

