/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class TargetingConditions {
    public static final TargetingConditions DEFAULT = TargetingConditions.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    public double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    @Nullable
    private Predicate<LivingEntity> selector;
    private boolean useFollowRange = false;

    private TargetingConditions(boolean attackable) {
        this.isCombat = attackable;
    }

    public static TargetingConditions forCombat() {
        return new TargetingConditions(true);
    }

    public static TargetingConditions forNonCombat() {
        return new TargetingConditions(false);
    }

    public TargetingConditions copy() {
        TargetingConditions targetingConditions = this.isCombat ? TargetingConditions.forCombat() : TargetingConditions.forNonCombat();
        targetingConditions.range = this.range;
        targetingConditions.checkLineOfSight = this.checkLineOfSight;
        targetingConditions.testInvisible = this.testInvisible;
        targetingConditions.selector = this.selector;
        return targetingConditions;
    }

    public TargetingConditions range(double baseMaxDistance) {
        this.range = baseMaxDistance;
        return this;
    }

    public TargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public TargetingConditions ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public TargetingConditions selector(@Nullable Predicate<LivingEntity> predicate) {
        this.selector = predicate;
        return this;
    }

    public boolean test(@Nullable LivingEntity baseEntity, LivingEntity targetEntity) {
        ServerPlayer player;
        if (baseEntity == targetEntity) {
            return false;
        }
        if (!targetEntity.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(targetEntity)) {
            return false;
        }
        if (!targetEntity.level().purpurConfig.idleTimeoutTargetPlayer && targetEntity instanceof ServerPlayer && (player = (ServerPlayer)targetEntity).isAfk()) {
            return false;
        }
        if (baseEntity == null) {
            if (this.isCombat && (!targetEntity.canBeSeenAsEnemy() || targetEntity.level().getDifficulty() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob mob;
            if (this.isCombat && (!baseEntity.canAttack(targetEntity) || !baseEntity.canAttackType(targetEntity.getType()) || baseEntity.isAlliedTo(targetEntity))) {
                return false;
            }
            if (this.range > 0.0) {
                double d = this.testInvisible ? targetEntity.getVisibilityPercent(baseEntity) : 1.0;
                double e = Math.max((this.useFollowRange ? this.getFollowRange(baseEntity) : this.range) * d, 2.0);
                double f = baseEntity.distanceToSqr(targetEntity.getX(), targetEntity.getY(), targetEntity.getZ());
                if (f > e * e) {
                    return false;
                }
            }
            if (this.checkLineOfSight && baseEntity instanceof Mob && !(mob = (Mob)baseEntity).getSensing().hasLineOfSight(targetEntity)) {
                return false;
            }
        }
        return true;
    }

    public TargetingConditions useFollowRange() {
        this.useFollowRange = true;
        return this;
    }

    private double getFollowRange(LivingEntity entityliving) {
        AttributeInstance attributeinstance = entityliving.getAttribute(Attributes.FOLLOW_RANGE);
        return attributeinstance == null ? 16.0 : attributeinstance.getValue();
    }
}

