/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.entity.ai.HasRider;

public class SnowGolem
extends AbstractGolem
implements Shearable,
RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_PUMPKIN_ID = SynchedEntityData.defineId(SnowGolem.class, EntityDataSerializers.BYTE);
    private static final byte PUMPKIN_FLAG = 16;
    @Nullable
    private UUID summoner;

    public SnowGolem(EntityType<? extends SnowGolem> type, Level world) {
        super((EntityType<? extends AbstractGolem>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.snowGolemRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.snowGolemRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.snowGolemControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.snowGolemMaxHealth);
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.snowGolemAlwaysDropExp;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(1, new RangedAttackGoal(this, this.level().purpurConfig.snowGolemAttackDistance, this.level().purpurConfig.snowGolemSnowBallMin, this.level().purpurConfig.snowGolemSnowBallMax, this.level().purpurConfig.snowGolemSnowBallModifier));
        this.goalSelector.addGoal(2, new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, entityliving -> entityliving instanceof Enemy));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PUMPKIN_ID, (byte)16);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Pumpkin", this.hasPumpkin());
        if (this.getSummoner() != null) {
            nbt.putUUID("Purpur.Summoner", this.getSummoner());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("Pumpkin")) {
            this.setPumpkin(nbt.getBoolean("Pumpkin"));
        }
        if (nbt.contains("Purpur.Summoner")) {
            this.setSummoner(nbt.getUUID("Purpur.Summoner"));
        }
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.snowGolemTakeDamageFromWater;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
                this.hurt(this.damageSources().melting(), 1.0f);
            }
            if (!this.level().purpurConfig.snowGolemBypassMobGriefing && !this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            if (this.getRider() != null && this.isControllable() && !this.level().purpurConfig.snowGolemLeaveTrailWhenRidden) {
                return;
            }
            BlockState iblockdata = Blocks.SNOW.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                int j = Mth.floor(this.getX() + (double)((float)(i % 2 * 2 - 1) * 0.25f));
                int k = Mth.floor(this.getY());
                int l = Mth.floor(this.getZ() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f));
                BlockPos blockposition = new BlockPos(j, k, l);
                if (!this.level().getBlockState(blockposition).isAir() || !iblockdata.canSurvive(this.level(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, this)) continue;
                this.level().gameEvent(GameEvent.BLOCK_PLACE, blockposition, GameEvent.Context.of(this, iblockdata));
            }
        }
    }

    @Override
    public void performRangedAttack(LivingEntity target, float pullProgress) {
        Snowball entitysnowball = new Snowball(this.level(), this);
        double d0 = target.getEyeY() - (double)1.1f;
        double d1 = target.getX() - this.getX();
        double d2 = d0 - entitysnowball.getY();
        double d3 = target.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.shoot(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity(entitysnowball);
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            List<ItemStack> drops = this.generateDefaultDrops(EnchantmentHelper.getMobLooting(player));
            PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
            if (event != null) {
                if (event.isCancelled()) {
                    return this.tryRide(player, hand);
                }
                drops = CraftItemStack.asNMSCopy(event.getDrops());
            }
            this.shear(SoundSource.PLAYERS, drops);
            this.gameEvent(GameEvent.SHEAR, player);
            if (!this.level().isClientSide) {
                itemstack.hurtAndBreak(1, player, SnowGolem.getSlotForHand(hand));
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.level().purpurConfig.snowGolemPutPumpkinBack && !this.hasPumpkin() && itemstack.getItem() == Blocks.CARVED_PUMPKIN.asItem()) {
            this.setPumpkin(true);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return this.tryRide(player, hand);
    }

    @Override
    public void shear(SoundSource shearedSoundCategory) {
        this.shear(shearedSoundCategory, this.generateDefaultDrops(0));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(int looting) {
        if (PurpurConfig.allowShearsLooting) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < 1 + looting; ++i) {
                list.add(new ItemStack(Items.CARVED_PUMPKIN));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.singletonList(new ItemStack(Items.CARVED_PUMPKIN));
    }

    @Override
    public void shear(SoundSource shearedSoundCategory, List<ItemStack> drops) {
        this.level().playSound((Player)null, this, SoundEvents.SNOW_GOLEM_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.setPumpkin(false);
            for (ItemStack drop : drops) {
                this.forceDrops = true;
                this.spawnAtLocation(drop, this.getEyeHeight());
                this.forceDrops = false;
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.hasPumpkin();
    }

    public boolean hasPumpkin() {
        return (this.entityData.get(DATA_PUMPKIN_ID) & 0x10) != 0;
    }

    public void setPumpkin(boolean hasPumpkin) {
        byte b0 = this.entityData.get(DATA_PUMPKIN_ID);
        if (hasPumpkin) {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 | 0x10));
        } else {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    public SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }
}

