/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.destroystokyo.paper.event.entity.SkeletonHorseTrapEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public class SkeletonTrapGoal
extends Goal {
    private final SkeletonHorse horse;
    private List<HumanEntity> eligiblePlayers;

    public SkeletonTrapGoal(SkeletonHorse skeletonHorse) {
        this.horse = skeletonHorse;
    }

    @Override
    public boolean canUse() {
        this.eligiblePlayers = this.horse.level().findNearbyBukkitPlayers(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0, EntitySelector.PLAYER_AFFECTS_SPAWNING);
        return !this.eligiblePlayers.isEmpty();
    }

    @Override
    public void tick() {
        ServerLevel worldserver = (ServerLevel)this.horse.level();
        if (!new SkeletonHorseTrapEvent((org.bukkit.entity.SkeletonHorse)this.horse.getBukkitEntity(), this.eligiblePlayers).callEvent()) {
            return;
        }
        DifficultyInstance difficultydamagescaler = worldserver.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        LightningBolt entitylightning = EntityType.LIGHTNING_BOLT.create(worldserver);
        if (entitylightning != null) {
            entitylightning.moveTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entitylightning.setVisualOnly(true);
            worldserver.strikeLightning(entitylightning, LightningStrikeEvent.Cause.TRAP);
            Skeleton entityskeleton = this.createSkeleton(difficultydamagescaler, this.horse);
            if (entityskeleton != null) {
                entityskeleton.startRiding(this.horse);
                worldserver.addFreshEntityWithPassengers(entityskeleton, CreatureSpawnEvent.SpawnReason.TRAP);
                for (int i = 0; i < 3; ++i) {
                    Skeleton entityskeleton1;
                    AbstractHorse entityhorseabstract = this.createHorse(difficultydamagescaler);
                    if (entityhorseabstract == null || (entityskeleton1 = this.createSkeleton(difficultydamagescaler, entityhorseabstract)) == null) continue;
                    entityskeleton1.startRiding(entityhorseabstract);
                    entityhorseabstract.push(this.horse.getRandom().triangle(0.0, 1.1485), 0.0, this.horse.getRandom().triangle(0.0, 1.1485));
                    worldserver.addFreshEntityWithPassengers(entityhorseabstract, CreatureSpawnEvent.SpawnReason.JOCKEY);
                }
            }
        }
    }

    @Nullable
    private AbstractHorse createHorse(DifficultyInstance localDifficulty) {
        SkeletonHorse entityhorseskeleton = EntityType.SKELETON_HORSE.create((Level)this.horse.level());
        if (entityhorseskeleton != null) {
            entityhorseskeleton.finalizeSpawn((ServerLevel)this.horse.level(), localDifficulty, MobSpawnType.TRIGGERED, null);
            entityhorseskeleton.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            entityhorseskeleton.invulnerableTime = 60;
            entityhorseskeleton.setPersistenceRequired();
            entityhorseskeleton.setTamed(true);
            entityhorseskeleton.setAge(0);
        }
        return entityhorseskeleton;
    }

    @Nullable
    private Skeleton createSkeleton(DifficultyInstance localDifficulty, AbstractHorse vehicle) {
        Skeleton entityskeleton = EntityType.SKELETON.create((Level)vehicle.level());
        if (entityskeleton != null) {
            entityskeleton.finalizeSpawn((ServerLevel)vehicle.level(), localDifficulty, MobSpawnType.TRIGGERED, null);
            entityskeleton.setPos(vehicle.getX(), vehicle.getY(), vehicle.getZ());
            entityskeleton.invulnerableTime = 60;
            entityskeleton.setPersistenceRequired();
            if (entityskeleton.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                entityskeleton.setItemSlot(EquipmentSlot.HEAD, new ItemStack(Items.IRON_HELMET));
            }
            FeatureFlagSet featureflagset = vehicle.level().enabledFeatures();
            entityskeleton.setItemSlot(EquipmentSlot.MAINHAND, EnchantmentHelper.enchantItem(featureflagset, entityskeleton.getRandom(), this.disenchant(entityskeleton.getMainHandItem()), (int)(5.0f + localDifficulty.getSpecialMultiplier() * (float)entityskeleton.getRandom().nextInt(18)), false));
            entityskeleton.setItemSlot(EquipmentSlot.HEAD, EnchantmentHelper.enchantItem(featureflagset, entityskeleton.getRandom(), this.disenchant(entityskeleton.getItemBySlot(EquipmentSlot.HEAD)), (int)(5.0f + localDifficulty.getSpecialMultiplier() * (float)entityskeleton.getRandom().nextInt(18)), false));
        }
        return entityskeleton;
    }

    private ItemStack disenchant(ItemStack stack) {
        stack.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return stack;
    }
}

