/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Slime
extends Mob
implements Enemy {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.defineId(Slime.class, EntityDataSerializers.INT);
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;
    public static final int MAX_NATURAL_SIZE = 4;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;
    protected boolean actualJump;
    private boolean canWander = true;

    public Slime(EntityType<? extends Slime> type, Level world) {
        super((EntityType<? extends Mob>)type, world);
        this.fixupDimensions();
        this.moveControl = new SlimeMoveControl(this);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.slimeRidable;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.slimeTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.slimeAlwaysDropExp;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.slimeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.slimeControllable;
    }

    @Override
    public float getJumpPower() {
        float height = super.getJumpPower();
        return this.getRider() != null && this.isControllable() && this.actualJump ? height * 1.5f : height;
    }

    @Override
    public boolean onSpacebar() {
        if (this.onGround && this.getRider() != null && this.isControllable()) {
            this.actualJump = true;
            if (this.getRider().getForwardMot() == 0.0f || this.getRider().getStrafeMot() == 0.0f) {
                this.jumpFromGround();
            }
        }
        return true;
    }

    protected String getMaxHealthEquation() {
        return this.level().purpurConfig.slimeMaxHealth;
    }

    protected String getAttackDamageEquation() {
        return this.level().purpurConfig.slimeAttackDamage;
    }

    protected Map<Integer, Double> getMaxHealthCache() {
        return this.level().purpurConfig.slimeMaxHealthCache;
    }

    protected Map<Integer, Double> getAttackDamageCache() {
        return this.level().purpurConfig.slimeAttackDamageCache;
    }

    protected double getFromCache(Supplier<String> equation, Supplier<Map<Integer, Double>> cache, Supplier<Double> defaultValue) {
        int size = this.getSize();
        Double value = cache.get().get(size);
        if (value == null) {
            try {
                value = ((Number)Entity.scriptEngine.eval("let size = " + size + "; " + equation.get())).doubleValue();
            }
            catch (ScriptException e) {
                e.printStackTrace();
                value = defaultValue.get();
            }
            cache.get().put(size, value);
        }
        return value;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(1, new SlimeFloatGoal(this));
        this.goalSelector.addGoal(2, new SlimeAttackGoal(this));
        this.goalSelector.addGoal(3, new SlimeRandomDirectionGoal(this));
        this.goalSelector.addGoal(5, new SlimeKeepOnJumpingGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, entityliving -> Math.abs(entityliving.getY() - this.getY()) <= 4.0));
        this.targetSelector.addGoal(3, new NearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, true));
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_SIZE, 1);
    }

    @VisibleForTesting
    public void setSize(int size, boolean heal) {
        int j = Mth.clamp(size, 1, 127);
        this.entityData.set(ID_SIZE, j);
        this.reapplyPosition();
        this.refreshDimensions();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.getFromCache(this::getMaxHealthEquation, this::getMaxHealthCache, () -> (double)size * (double)size));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2f + 0.1f * (float)j);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.getFromCache(this::getAttackDamageEquation, this::getAttackDamageCache, () -> j));
        if (heal) {
            this.setHealth(this.getMaxHealth());
        }
        this.xpReward = j;
    }

    public int getSize() {
        return this.entityData.get(ID_SIZE);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Paper.canWander", this.canWander);
        nbt.putInt("Size", this.getSize() - 1);
        nbt.putBoolean("wasOnGround", this.wasOnGround);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setSize(nbt.getInt("Size") + 1, false);
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("Paper.canWander")) {
            this.canWander = nbt.getBoolean("Paper.canWander");
        }
        this.wasOnGround = nbt.getBoolean("wasOnGround");
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.ITEM_SLIME;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return this.getSize() > 0;
    }

    @Override
    public void tick() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.tick();
        if (this.onGround() && !this.wasOnGround) {
            float f = this.getDimensions(this.getPose()).width() * 2.0f;
            float f1 = f / 2.0f;
            int i = 0;
            while ((float)i < f * 16.0f) {
                float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f3 = this.random.nextFloat() * 0.5f + 0.5f;
                float f4 = Mth.sin(f2) * f1 * f3;
                float f5 = Mth.cos(f2) * f1 * f3;
                this.level().addParticle(this.getParticleType(), this.getX() + (double)f4, this.getY(), this.getZ() + (double)f5, 0.0, 0.0, 0.0);
                ++i;
            }
            this.playSound(this.getSquishSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.onGround() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.onGround();
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.random.nextInt(20) + 10;
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (ID_SIZE.equals(data)) {
            this.refreshDimensions();
            this.setYRot(this.yHeadRot);
            this.yBodyRot = this.yHeadRot;
            if (this.isInWater() && this.random.nextInt(20) == 0) {
                this.doWaterSplashEffect();
            }
        }
        super.onSyncedDataUpdated(data);
    }

    public EntityType<? extends Slime> getType() {
        return super.getType();
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i = this.getSize();
        if (!this.level().isClientSide && i > 1 && this.isDeadOrDying()) {
            Component ichatbasecomponent = this.getCustomName();
            boolean flag = this.isNoAi();
            float f = this.getDimensions(this.getPose()).width();
            float f1 = f / 2.0f;
            int j = i / 2;
            int k = 2 + this.random.nextInt(3);
            SlimeSplitEvent event = new SlimeSplitEvent((org.bukkit.entity.Slime)this.getBukkitEntity(), k);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k = event.getCount();
            ArrayList<LivingEntity> slimes = new ArrayList<LivingEntity>(j);
            for (int l = 0; l < k; ++l) {
                float f2 = ((float)(l % 2) - 0.5f) * f1;
                float f3 = ((float)(l / 2) - 0.5f) * f1;
                Slime entityslime = this.getType().create(this.level());
                if (entityslime == null) continue;
                if (this.isPersistenceRequired()) {
                    entityslime.setPersistenceRequired();
                }
                entityslime.aware = this.aware;
                entityslime.setCustomName(ichatbasecomponent);
                entityslime.setNoAi(flag);
                entityslime.setInvulnerable(this.isInvulnerable());
                entityslime.setSize(j, true);
                entityslime.moveTo(this.getX() + (double)f2, this.getY() + 0.5, this.getZ() + (double)f3, this.random.nextFloat() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((LivingEntity)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (LivingEntity living : slimes) {
                this.level().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void push(Entity entity) {
        super.push(entity);
        if (entity instanceof IronGolem && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)entity);
        }
    }

    @Override
    public void playerTouch(Player player) {
        if (this.isDealsDamage()) {
            this.dealDamage(player);
        }
    }

    protected void dealDamage(LivingEntity target) {
        if (this.isAlive()) {
            int i = this.getSize();
            if (this.distanceToSqr(target) < 0.6 * (double)i * 0.6 * (double)i && this.hasLineOfSight(target) && target.hurt(this.damageSources().mobAttack(this), this.getAttackDamage())) {
                this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.doEnchantDamageEffects(this, target);
            }
        }
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        return new Vec3(0.0, (double)dimensions.height() - 0.015625 * (double)this.getSize() * (double)scaleFactor, 0.0);
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.isEffectiveAi();
    }

    protected float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isTiny() ? SoundEvents.SLIME_HURT_SMALL : SoundEvents.SLIME_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return this.isTiny() ? SoundEvents.SLIME_DEATH_SMALL : SoundEvents.SLIME_DEATH;
    }

    protected SoundEvent getSquishSound() {
        return this.isTiny() ? SoundEvents.SLIME_SQUISH_SMALL : SoundEvents.SLIME_SQUISH;
    }

    public static boolean checkSlimeSpawnRules(EntityType<Slime> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        if (MobSpawnType.isSpawner(spawnReason)) {
            return Slime.checkMobSpawnRules(type, world, spawnReason, pos, random);
        }
        if (world.getDifficulty() != Difficulty.PEACEFUL) {
            if (spawnReason == MobSpawnType.SPAWNER) {
                return Slime.checkMobSpawnRules(type, world, spawnReason, pos, random);
            }
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (world.getBiome(pos).is(BiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS) && (double)pos.getY() > minHeightSwamp && (double)pos.getY() < maxHeightSwamp && random.nextFloat() < 0.5f && random.nextFloat() < world.getMoonBrightness() && world.getMaxLocalRawBrightness(pos) <= random.nextInt(8)) {
                return Slime.checkMobSpawnRules(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof WorldGenLevel)) {
                return false;
            }
            ChunkPos chunkcoordintpair = new ChunkPos(pos);
            boolean flag = world.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || WorldgenRandom.seedSlimeChunk(chunkcoordintpair.x, chunkcoordintpair.z, ((WorldGenLevel)world).getSeed(), world.getMinecraftWorld().spigotConfig.slimeSeed).nextInt(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.nextInt(10) == 0 && flag && (double)pos.getY() < maxHeightSlimeChunk) {
                return Slime.checkMobSpawnRules(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float getSoundVolume() {
        return 0.4f * (float)this.getSize();
    }

    @Override
    public int getMaxHeadXRot() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    @Override
    public void jumpFromGround() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x, this.getJumpPower(), vec3d.z);
        this.hasImpulse = true;
        this.actualJump = false;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        RandomSource randomsource = world.getRandom();
        int i = randomsource.nextInt(3);
        if (i < 2 && randomsource.nextFloat() < 0.5f * difficulty.getSpecialMultiplier()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j, true);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? SoundEvents.SLIME_JUMP_SMALL : SoundEvents.SLIME_JUMP;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getSize());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class SlimeMoveControl
    extends MoveControllerWASD {
        private float yRot;
        private int jumpDelay;
        private final Slime slime;
        private boolean isAggressive;

        public SlimeMoveControl(Slime slime) {
            super(slime);
            this.slime = slime;
            this.yRot = 180.0f * slime.getYRot() / (float)Math.PI;
        }

        public void setDirection(float targetYaw, boolean jumpOften) {
            this.yRot = targetYaw;
            this.isAggressive = jumpOften;
        }

        public void setWantedMovement(double speed) {
            this.setSpeedModifier(speed);
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        @Override
        public void tick() {
            if (this.slime.getRider() != null && this.slime.isControllable()) {
                this.purpurTick(this.slime.getRider());
                if (this.slime.getForwardMot() != 0.0f || this.slime.getStrafeMot() != 0.0f) {
                    if (this.jumpDelay > 10) {
                        this.jumpDelay = 6;
                    }
                } else {
                    this.jumpDelay = 20;
                }
            } else {
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.yRot, 90.0f));
                this.mob.yHeadRot = this.mob.getYRot();
                this.mob.yBodyRot = this.mob.getYRot();
            }
            if (!(this.slime.getRider() != null && this.slime.isControllable() || this.operation == MoveControl.Operation.MOVE_TO)) {
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.getSpeedModifier() * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.slime.getRider() != null && this.slime.isControllable() && (this.slime.getRider().getForwardMot() != 0.0f || this.slime.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.getJumpControl().jump();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.playSound(this.slime.getJumpSound(), this.slime.getSoundVolume(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.xxa = 0.0f;
                        this.slime.zza = 0.0f;
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.mob.setSpeed((float)(this.getSpeedModifier() * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.slime.getRider() != null && this.slime.isControllable() && (this.slime.getRider().getForwardMot() != 0.0f || this.slime.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                }
            }
        }
    }

    private static class SlimeFloatGoal
    extends Goal {
        private final Slime slime;

        public SlimeFloatGoal(Slime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slime.getNavigation().setCanFloat(true);
        }

        @Override
        public boolean canUse() {
            return (this.slime.isInWater() || this.slime.isInLava()) && this.slime.getMoveControl() instanceof SlimeMoveControl && this.slime.canWander && new SlimeSwimEvent((org.bukkit.entity.Slime)this.slime.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            MoveControl controllermove;
            if (this.slime.getRandom().nextFloat() < 0.8f) {
                this.slime.getJumpControl().jump();
            }
            if ((controllermove = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl entityslime_controllermoveslime = (SlimeMoveControl)controllermove;
                entityslime_controllermoveslime.setWantedMovement(1.2);
            }
        }
    }

    private static class SlimeAttackGoal
    extends Goal {
        private final Slime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(Slime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            LivingEntity entityliving = this.slime.getTarget();
            if (entityliving == null || !entityliving.isAlive()) {
                return false;
            }
            if (!this.slime.canAttack(entityliving)) {
                return false;
            }
            return this.slime.getMoveControl() instanceof SlimeMoveControl && this.slime.canWander && new SlimeTargetLivingEntityEvent((org.bukkit.entity.Slime)this.slime.getBukkitEntity(), (org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void start() {
            this.growTiredTimer = SlimeAttackGoal.reducedTickDelay(300);
            super.start();
        }

        @Override
        public boolean canContinueToUse() {
            LivingEntity entityliving = this.slime.getTarget();
            if (entityliving == null || !entityliving.isAlive()) {
                return false;
            }
            if (!this.slime.canAttack(entityliving)) {
                return false;
            }
            return --this.growTiredTimer > 0 && this.slime.canWander && new SlimeTargetLivingEntityEvent((org.bukkit.entity.Slime)this.slime.getBukkitEntity(), (org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            MoveControl controllermove;
            LivingEntity entityliving = this.slime.getTarget();
            if (entityliving != null) {
                this.slime.lookAt(entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl entityslime_controllermoveslime = (SlimeMoveControl)controllermove;
                entityslime_controllermoveslime.setDirection(this.slime.getYRot(), this.slime.isDealsDamage());
            }
        }

        @Override
        public void stop() {
            this.growTiredTimer = 0;
            this.slime.setTarget(null);
        }
    }

    private static class SlimeRandomDirectionGoal
    extends Goal {
        private final Slime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(Slime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return this.slime.getTarget() == null && (this.slime.onGround() || this.slime.isInWater() || this.slime.isInLava() || this.slime.hasEffect(MobEffects.LEVITATION)) && this.slime.getMoveControl() instanceof SlimeMoveControl && this.slime.canWander;
        }

        @Override
        public void tick() {
            MoveControl controllermove;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
                this.chosenDegrees = this.slime.getRandom().nextInt(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((org.bukkit.entity.Slime)this.slime.getBukkitEntity(), this.chosenDegrees);
                if (!this.slime.canWander || !event.callEvent()) {
                    return;
                }
                this.chosenDegrees = event.getNewYaw();
            }
            if ((controllermove = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl entityslime_controllermoveslime = (SlimeMoveControl)controllermove;
                entityslime_controllermoveslime.setDirection(this.chosenDegrees, false);
            }
        }
    }

    private static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final Slime slime;

        public SlimeKeepOnJumpingGoal(Slime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            return !this.slime.isPassenger() && this.slime.canWander && new SlimeWanderEvent((org.bukkit.entity.Slime)this.slime.getBukkitEntity()).callEvent();
        }

        @Override
        public void tick() {
            MoveControl controllermove = this.slime.getMoveControl();
            if (controllermove instanceof SlimeMoveControl) {
                SlimeMoveControl entityslime_controllermoveslime = (SlimeMoveControl)controllermove;
                entityslime_controllermoveslime.setWantedMovement(1.0);
            }
        }
    }
}

