/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindCharge
extends AbstractHurtingProjectile
implements ItemSupplier {
    public static final WindChargeDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new WindChargeDamageCalculator();

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, Level world) {
        super((EntityType<? extends AbstractHurtingProjectile>)type, world);
    }

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, Level world, Entity owner, double x, double y, double z) {
        super(type, x, y, z, world);
        this.setOwner(owner);
    }

    AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, double x, double y, double z, double directionX, double directionY, double directionZ, Level world) {
        super(type, x, y, z, directionX, directionY, directionZ, world);
    }

    @Override
    protected AABB makeBoundingBox() {
        float f = this.getType().getDimensions().width() / 2.0f;
        float f1 = this.getType().getDimensions().height();
        float f2 = 0.15f;
        return new AABB(this.position().x - (double)f, this.position().y - (double)0.15f, this.position().z - (double)f, this.position().x + (double)f, this.position().y - (double)0.15f + (double)f1, this.position().z + (double)f);
    }

    @Override
    public boolean canCollideWith(Entity other) {
        return other instanceof AbstractWindCharge ? false : super.canCollideWith(other);
    }

    @Override
    public boolean canHitEntity(Entity entity) {
        return entity instanceof AbstractWindCharge ? false : (entity.getType() == EntityType.END_CRYSTAL ? false : super.canHitEntity(entity));
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            LivingEntity entityliving1;
            Entity entity = this.getOwner();
            LivingEntity entityliving = entity instanceof LivingEntity ? (entityliving1 = (LivingEntity)entity) : null;
            LivingEntity entityliving2 = entityliving;
            Entity entity1 = entityHitResult.getEntity().getPassengerClosestTo(entityHitResult.getLocation()).orElse(entityHitResult.getEntity());
            if (entityliving2 != null) {
                entityliving2.setLastHurtMob(entity1);
            }
            entity1.hurt(this.damageSources().windCharge(this, entityliving2), 1.0f);
            this.explode();
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
    }

    public abstract void explode();

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            this.explode();
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @javax.annotation.Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode();
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
        } else {
            super.tick();
        }
    }

    public static class WindChargeDamageCalculator
    extends ExplosionDamageCalculator {
        @Override
        public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
            return false;
        }

        @Override
        public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState) {
            return blockState.is(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS) ? Optional.of(Float.valueOf(3600000.0f)) : Optional.empty();
        }
    }
}

