/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.inventory.InventoryView;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private final Container horseContainer;
    private final Container armorContainer;
    private final AbstractHorse horse;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;
    CraftInventoryView bukkitEntity;
    Inventory player;

    @Override
    public InventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        this.bukkitEntity = new CraftInventoryView(this.player.player.getBukkitEntity(), this.horseContainer.getOwner().getInventory(), this);
        return this.bukkitEntity;
    }

    public HorseInventoryMenu(int syncId, Inventory playerInventory, Container inventory, final AbstractHorse entity) {
        super(null, syncId);
        int k;
        int j;
        this.player = playerInventory;
        this.horseContainer = inventory;
        this.armorContainer = entity.getBodyArmorAccess();
        this.horse = entity;
        boolean flag = true;
        inventory.startOpen(playerInventory.player);
        boolean flag1 = true;
        this.addSlot(new Slot(this, inventory, 0, 8, 18){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.SADDLE) && !this.hasItem() && entity.isSaddleable();
            }

            @Override
            public boolean isActive() {
                return entity.isSaddleable();
            }
        });
        this.addSlot(new Slot(this, this.armorContainer, 0, 8, 36){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return entity.isBodyArmorItem(stack);
            }

            @Override
            public boolean isActive() {
                return entity.canWearBodyArmor();
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        if (this.hasChest(entity)) {
            for (j = 0; j < 3; ++j) {
                for (k = 0; k < ((AbstractChestedHorse)entity).getInventoryColumns(); ++k) {
                    this.addSlot(new Slot(inventory, 1 + k + j * ((AbstractChestedHorse)entity).getInventoryColumns(), 80 + k * 18, 18 + j * 18));
                }
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot(playerInventory, k + j * 9 + 9, 8 + k * 18, 102 + j * 18 + -18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot(playerInventory, j, 8 + j * 18, 142));
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(player) && this.armorContainer.stillValid(player) && this.horse.isAlive() && player.canInteractWithEntity(this.horse, 4.0);
    }

    private boolean hasChest(AbstractHorse horse) {
        AbstractChestedHorse entityhorsechestedabstract;
        if (horse instanceof AbstractChestedHorse && (entityhorsechestedabstract = (AbstractChestedHorse)horse).hasChest()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot1 = this.slots.get(slot);
        if (slot1 != null && slot1.hasItem()) {
            ItemStack itemstack1 = slot1.getItem();
            itemstack = itemstack1.copy();
            int j = this.horseContainer.getContainerSize() + 1;
            if (slot < j) {
                if (!this.moveItemStackTo(itemstack1, j, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (j <= 1 || !this.moveItemStackTo(itemstack1, 2, j, false)) {
                int k = j + 27;
                int l = k + 9;
                if (slot >= k && slot < l ? !this.moveItemStackTo(itemstack1, j, k, false) : (slot >= j && slot < k ? !this.moveItemStackTo(itemstack1, k, l, false) : !this.moveItemStackTo(itemstack1, k, k, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            } else {
                slot1.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.horseContainer.stopOpen(player);
    }
}

