/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LeadItem
extends Item {
    public LeadItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockposition;
        Level world = context.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = context.getClickedPos());
        if (iblockdata.is(BlockTags.FENCES)) {
            Player entityhuman = context.getPlayer();
            if (!world.isClientSide && entityhuman != null) {
                LeadItem.bindPlayerMobs(entityhuman, world, blockposition, context.getHand());
            }
            return InteractionResult.sidedSuccess(world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player entityhuman, Level world, BlockPos blockposition, InteractionHand enumhand) {
        Entity entityleash = null;
        double d0 = 7.0;
        int i = blockposition.getX();
        int j = blockposition.getY();
        int k = blockposition.getZ();
        AABB axisalignedbb = new AABB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0);
        List<Mob> list = world.getEntitiesOfClass(Mob.class, axisalignedbb, entityinsentient -> entityinsentient.getLeashHolder() == entityhuman);
        Iterator<Mob> iterator = list.iterator();
        while (iterator.hasNext()) {
            Mob entityinsentient2 = iterator.next();
            if (entityleash == null) {
                entityleash = LeashFenceKnotEntity.getOrCreateKnot(world, blockposition);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityleash.getBukkitEntity(), entityhuman != null ? (org.bukkit.entity.Player)entityhuman.getBukkitEntity() : null, world.getWorld().getBlockAt(i, j, k), BlockFace.SELF, hand);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entityleash.discard(null);
                    return InteractionResult.PASS;
                }
                ((LeashFenceKnotEntity)entityleash).playPlacementSound();
            }
            if (CraftEventFactory.callPlayerLeashEntityEvent(entityinsentient2, entityleash, entityhuman, enumhand).isCancelled()) {
                iterator.remove();
                continue;
            }
            entityinsentient2.setLeashedTo(entityleash, true);
        }
        if (!list.isEmpty()) {
            world.gameEvent(GameEvent.BLOCK_ATTACH, blockposition, GameEvent.Context.of(entityhuman));
            return InteractionResult.SUCCESS;
        }
        if (entityleash != null) {
            entityleash.discard(null);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player player, Level world, BlockPos pos) {
        return LeadItem.bindPlayerMobs(player, world, pos, InteractionHand.MAIN_HAND);
    }
}

