/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class MilkBucketItem
extends Item {
    private static final int DRINK_DURATION = 32;

    public MilkBucketItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (user instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(entityplayer, stack);
            entityplayer.awardStat(Stats.ITEM_USED.get(this));
        }
        stack.consume(1, user);
        if (!world.isClientSide) {
            MobEffectInstance badOmen = user.getEffect(MobEffects.BAD_OMEN);
            user.removeAllEffects(EntityPotionEffectEvent.Cause.MILK);
            if (!world.purpurConfig.milkCuresBadOmen && badOmen != null) {
                user.addEffect(badOmen);
            }
        }
        return stack.isEmpty() ? new ItemStack(Items.BUCKET) : stack;
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly(world, user, hand);
    }
}

