/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SpectralArrowItem
extends ArrowItem {
    public SpectralArrowItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public AbstractArrow createArrow(Level world, ItemStack stack, LivingEntity shooter) {
        return new SpectralArrow(world, shooter, stack.copyWithCount(1));
    }

    @Override
    @Override
    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        SpectralArrow spectralArrow = new SpectralArrow(world, pos.x(), pos.y(), pos.z(), stack.copyWithCount(1));
        spectralArrow.pickup = AbstractArrow.Pickup.ALLOWED;
        return spectralArrow;
    }
}

