/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;

public class StandingAndWallBlockItem
extends BlockItem {
    public final Block wallBlock;
    private final Direction attachmentDirection;

    public StandingAndWallBlockItem(Block standingBlock, Block wallBlock, Item.Properties settings, Direction verticalAttachmentDirection) {
        super(standingBlock, settings);
        this.wallBlock = wallBlock;
        this.attachmentDirection = verticalAttachmentDirection;
    }

    protected boolean canPlace(LevelReader world, BlockState state, BlockPos pos) {
        return state.canSurvive(world, pos);
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState iblockdata = this.wallBlock.getStateForPlacement(context);
        BlockState iblockdata1 = null;
        Level world = context.getLevel();
        BlockPos blockposition = context.getClickedPos();
        for (Direction enumdirection : context.getNearestLookingDirections()) {
            BlockState iblockdata2;
            if (enumdirection == this.attachmentDirection.getOpposite()) continue;
            BlockState blockState = iblockdata2 = enumdirection == this.attachmentDirection ? this.getBlock().getStateForPlacement(context) : iblockdata;
            if (iblockdata2 == null || !this.canPlace(world, iblockdata2, blockposition)) continue;
            iblockdata1 = iblockdata2;
            break;
        }
        if (iblockdata1 != null) {
            boolean defaultReturn = world.isUnobstructed(iblockdata1, blockposition, CollisionContext.empty());
            Player player = context.getPlayer() instanceof ServerPlayer ? (Player)context.getPlayer().getBukkitEntity() : null;
            BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), player, (BlockData)CraftBlockData.fromData(iblockdata1), defaultReturn, CraftEquipmentSlot.getHand(context.getHand()));
            context.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
            return event.isBuildable() ? iblockdata1 : null;
        }
        return null;
    }

    @Override
    public void registerBlocks(Map<Block, Item> map, Item item) {
        super.registerBlocks(map, item);
        map.put(this.wallBlock, item);
    }
}

