/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BookCloningRecipe
extends CustomRecipe {
    public BookCloningRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @Override
    public boolean matches(CraftingContainer inventory, Level world) {
        int i = 0;
        ItemStack itemStack = ItemStack.EMPTY;
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemStack2 = inventory.getItem(j);
            if (itemStack2.isEmpty()) continue;
            if (itemStack2.is(Items.WRITTEN_BOOK)) {
                if (!itemStack.isEmpty()) {
                    return false;
                }
                itemStack = itemStack2;
                continue;
            }
            if (itemStack2.is(Items.WRITABLE_BOOK)) {
                ++i;
                continue;
            }
            return false;
        }
        return !itemStack.isEmpty() && i > 0;
    }

    @Override
    @Override
    public ItemStack assemble(CraftingContainer inventory, HolderLookup.Provider lookup) {
        int i = 0;
        ItemStack itemStack = ItemStack.EMPTY;
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemStack2 = inventory.getItem(j);
            if (itemStack2.isEmpty()) continue;
            if (itemStack2.is(Items.WRITTEN_BOOK)) {
                if (!itemStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemStack = itemStack2;
                continue;
            }
            if (itemStack2.is(Items.WRITABLE_BOOK)) {
                ++i;
                continue;
            }
            return ItemStack.EMPTY;
        }
        WrittenBookContent writtenBookContent = itemStack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (itemStack.isEmpty() || i < 1 || writtenBookContent == null) {
            return ItemStack.EMPTY;
        }
        WrittenBookContent writtenBookContent2 = writtenBookContent.tryCraftCopy();
        if (writtenBookContent2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack3 = itemStack.copyWithCount(i);
        itemStack3.set(DataComponents.WRITTEN_BOOK_CONTENT, writtenBookContent2);
        return itemStack3;
    }

    @Override
    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList<ItemStack> nonNullList = NonNullList.withSize(inventory.getContainerSize(), ItemStack.EMPTY);
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.getItem().hasCraftingRemainingItem()) {
                nonNullList.set(i, new ItemStack(itemStack.getItem().getCraftingRemainingItem()));
                continue;
            }
            if (!(itemStack.getItem() instanceof WrittenBookItem)) continue;
            nonNullList.set(i, itemStack.copyWithCount(1));
            break;
        }
        return nonNullList;
    }

    @Override
    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.BOOK_CLONING;
    }

    @Override
    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

