/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ItemStack.LIST_STREAM_CODEC.map(list -> Ingredient.fromValues(list.stream().map(ItemValue::new)), recipeitemstack -> Arrays.asList(recipeitemstack.getItems()));
    private final Value[] values;
    @Nullable
    public ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public boolean exact;
    public Predicate<org.bukkit.inventory.ItemStack> predicate;
    public static final Codec<Ingredient> CODEC = Ingredient.codec(true);
    public static final Codec<Ingredient> CODEC_NONEMPTY = Ingredient.codec(false);

    public Ingredient(Stream<? extends Value> entries) {
        this.values = (Value[])entries.toArray(Value[]::new);
    }

    private Ingredient(Value[] entries) {
        this.values = entries;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(recipeitemstack_provider -> recipeitemstack_provider.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return itemstack.isEmpty();
        }
        if (this.predicate != null) {
            return this.predicate.test(itemstack.asBukkitCopy());
        }
        for (ItemStack itemstack1 : this.getItems()) {
            if (!(this.exact ? itemstack1.getItem() == itemstack.getItem() && ItemStack.isSameItemSameComponents(itemstack, itemstack1) : itemstack1.is(itemstack.getItem()))) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] aitemstack = this.getItems();
            this.stackingIds = new IntArrayList(aitemstack.length);
            ItemStack[] aitemstack1 = aitemstack;
            int i = aitemstack.length;
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = aitemstack1[j];
                this.stackingIds.add(StackedContents.getStackingIndex(itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Ingredient) {
            Ingredient recipeitemstack = (Ingredient)object;
            return Arrays.equals(this.values, recipeitemstack.values);
        }
        return false;
    }

    private static Ingredient fromValues(Stream<? extends Value> entries) {
        Ingredient recipeitemstack = new Ingredient(entries);
        return recipeitemstack.isEmpty() ? EMPTY : recipeitemstack;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient of(ItemLike ... items) {
        return Ingredient.of(Arrays.stream(items).map(ItemStack::new));
    }

    public static Ingredient of(ItemStack ... stacks) {
        return Ingredient.of(Arrays.stream(stacks));
    }

    public static Ingredient of(Stream<ItemStack> stacks) {
        return Ingredient.fromValues(stacks.filter(itemstack -> !itemstack.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> tag) {
        return Ingredient.fromValues(Stream.of(new TagValue(tag)));
    }

    private static Codec<Ingredient> codec(boolean allowEmpty) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(list -> !allowEmpty && list.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Value[0])), List::of);
        return Codec.either((Codec)codec, Value.CODEC).flatComapMap(either -> either.map(Ingredient::new, recipeitemstack_provider -> new Ingredient(new Value[]{recipeitemstack_provider})), recipeitemstack -> recipeitemstack.values.length == 1 ? DataResult.success(Either.right(recipeitemstack.values[0])) : (recipeitemstack.values.length == 0 && !allowEmpty ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success(Either.left(recipeitemstack.values))));
    }

    public static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap(either -> (Value)((Object)either.map(recipeitemstack_stackprovider -> recipeitemstack_stackprovider, recipeitemstack_b -> recipeitemstack_b)), recipeitemstack_provider -> {
            if (recipeitemstack_provider instanceof TagValue) {
                TagValue recipeitemstack_b = (TagValue)recipeitemstack_provider;
                return Either.right(recipeitemstack_b);
            }
            if (recipeitemstack_provider instanceof ItemValue) {
                ItemValue recipeitemstack_stackprovider = (ItemValue)recipeitemstack_provider;
                return Either.left(recipeitemstack_stackprovider);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    private record TagValue(TagKey<Item> tag) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(recipeitemstack_b -> recipeitemstack_b.tag)).apply((Applicative)instance, TagValue::new));

        @Override
        public boolean equals(Object object) {
            if (object instanceof TagValue) {
                TagValue recipeitemstack_b = (TagValue)object;
                return recipeitemstack_b.tag.location().equals(this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }
    }

    public record ItemValue(ItemStack item) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(recipeitemstack_stackprovider -> recipeitemstack_stackprovider.item)).apply((Applicative)instance, ItemValue::new));

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ItemValue)) {
                return false;
            }
            ItemValue recipeitemstack_stackprovider = (ItemValue)object;
            return recipeitemstack_stackprovider.item.getItem().equals(this.item.getItem()) && recipeitemstack_stackprovider.item.getCount() == this.item.getCount();
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

