/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SimpleCookingSerializer<T extends AbstractCookingRecipe>
implements RecipeSerializer<T> {
    private final AbstractCookingRecipe.Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public SimpleCookingSerializer(AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime) {
        this.factory = recipeFactory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)cookingTime).forGetter(recipe -> recipe.cookingTime)).apply((Applicative)instance, recipeFactory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @Override
    @Override
    public MapCodec<T> codec() {
        return this.codec;
    }

    @Override
    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf buf) {
        String string = buf.readUtf();
        CookingBookCategory cookingBookCategory = buf.readEnum(CookingBookCategory.class);
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
        ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
        float f = buf.readFloat();
        int i = buf.readVarInt();
        return this.factory.create(string, cookingBookCategory, ingredient, itemStack, f, i);
    }

    private void toNetwork(RegistryFriendlyByteBuf buf, T recipe) {
        buf.writeUtf(((AbstractCookingRecipe)recipe).group);
        buf.writeEnum(((AbstractCookingRecipe)recipe).category());
        Ingredient.CONTENTS_STREAM_CODEC.encode(buf, ((AbstractCookingRecipe)recipe).ingredient);
        ItemStack.STREAM_CODEC.encode(buf, ((AbstractCookingRecipe)recipe).result);
        buf.writeFloat(((AbstractCookingRecipe)recipe).experience);
        buf.writeVarInt(((AbstractCookingRecipe)recipe).cookingTime);
    }

    public AbstractCookingRecipe create(String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        return this.factory.create(group, category, ingredient, result, experience, cookingTime);
    }
}

