/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TippedArrowRecipe
extends CustomRecipe {
    public TippedArrowRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @Override
    public boolean matches(CraftingContainer inventory, Level world) {
        if (inventory.getWidth() != 3 || inventory.getHeight() != 3) {
            return false;
        }
        for (int i = 0; i < inventory.getWidth(); ++i) {
            for (int j = 0; j < inventory.getHeight(); ++j) {
                ItemStack itemStack = inventory.getItem(i + j * inventory.getWidth());
                if (itemStack.isEmpty()) {
                    return false;
                }
                if (!(i == 1 && j == 1 ? !itemStack.is(Items.LINGERING_POTION) : !itemStack.is(Items.ARROW))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Override
    public ItemStack assemble(CraftingContainer inventory, HolderLookup.Provider lookup) {
        ItemStack itemStack = inventory.getItem(1 + inventory.getWidth());
        if (!itemStack.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack2 = new ItemStack(Items.TIPPED_ARROW, 8);
        itemStack2.set(DataComponents.POTION_CONTENTS, itemStack.get(DataComponents.POTION_CONTENTS));
        return itemStack2;
    }

    @Override
    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Override
    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.TIPPED_ARROW;
    }
}

