/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Enchantment
implements FeatureElement {
    public final EnchantmentDefinition definition;
    @Nullable
    protected String descriptionId;
    private final Holder.Reference<Enchantment> builtInRegistryHolder = BuiltInRegistries.ENCHANTMENT.createIntrusiveHolder(this);

    public static Cost constantCost(int base) {
        return new Cost(base, 0);
    }

    public static Cost dynamicCost(int base, int perLevel) {
        return new Cost(base, perLevel);
    }

    public static EnchantmentDefinition definition(TagKey<Item> supportedItems, TagKey<Item> primaryItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, EquipmentSlot ... slots) {
        return new EnchantmentDefinition(supportedItems, Optional.of(primaryItems), weight, maxLevel, minCost, maxCost, anvilCost, FeatureFlags.DEFAULT_FLAGS, slots);
    }

    public static EnchantmentDefinition definition(TagKey<Item> supportedItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, EquipmentSlot ... slots) {
        return new EnchantmentDefinition(supportedItems, Optional.empty(), weight, maxLevel, minCost, maxCost, anvilCost, FeatureFlags.DEFAULT_FLAGS, slots);
    }

    public static EnchantmentDefinition definition(TagKey<Item> supportedItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, FeatureFlagSet requiredFeatures, EquipmentSlot ... slots) {
        return new EnchantmentDefinition(supportedItems, Optional.empty(), weight, maxLevel, minCost, maxCost, anvilCost, requiredFeatures, slots);
    }

    @Nullable
    public static Enchantment byId(int id) {
        return (Enchantment)BuiltInRegistries.ENCHANTMENT.byId(id);
    }

    public Enchantment(EnchantmentDefinition properties) {
        this.definition = properties;
    }

    public Map<EquipmentSlot, ItemStack> getSlotItems(LivingEntity entity) {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        for (EquipmentSlot equipmentSlot : this.definition.slots()) {
            ItemStack itemStack = entity.getItemBySlot(equipmentSlot);
            if (itemStack.isEmpty()) continue;
            map.put(equipmentSlot, itemStack);
        }
        return map;
    }

    public final TagKey<Item> getSupportedItems() {
        return this.definition.supportedItems();
    }

    public final boolean isPrimaryItem(ItemStack stack) {
        return this.definition.primaryItems.isEmpty() || stack.is(this.definition.primaryItems.get());
    }

    public final int getWeight() {
        return this.definition.weight();
    }

    public final int getAnvilCost() {
        return this.definition.anvilCost();
    }

    public final int getMinLevel() {
        return 1;
    }

    public final int getMaxLevel() {
        return this.definition.maxLevel();
    }

    public final int getMinCost(int level) {
        return this.definition.minCost().calculate(level);
    }

    public final int getMaxCost(int level) {
        return this.definition.maxCost().calculate(level);
    }

    public int getDamageProtection(int level, DamageSource source) {
        return 0;
    }

    public float getDamageBonus(int level, @Nullable EntityType<?> entityType) {
        return 0.0f;
    }

    public final boolean isCompatibleWith(Enchantment other) {
        return this.checkCompatibility(other) && other.checkCompatibility(this);
    }

    protected boolean checkCompatibility(Enchantment other) {
        return this != other;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId("enchantment", BuiltInRegistries.ENCHANTMENT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullname(int level) {
        MutableComponent mutableComponent = Component.translatable(this.getDescriptionId());
        if (this.isCurse()) {
            mutableComponent.withStyle(ChatFormatting.RED);
        } else {
            mutableComponent.withStyle(ChatFormatting.GRAY);
        }
        if (level != 1 || this.getMaxLevel() != 1) {
            mutableComponent.append(CommonComponents.SPACE).append(Component.translatable("enchantment.level." + level));
        }
        return mutableComponent;
    }

    public boolean canEnchant(ItemStack stack) {
        return stack.getItem().builtInRegistryHolder().is(this.definition.supportedItems());
    }

    public void doPostAttack(LivingEntity user, Entity target, int level) {
    }

    public void doPostHurt(LivingEntity user, Entity attacker, int level) {
    }

    public void doPostItemStackHurt(LivingEntity attacket, Entity target, int level) {
    }

    public boolean isTreasureOnly() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean isTradeable() {
        return true;
    }

    public boolean isDiscoverable() {
        return true;
    }

    @Deprecated
    public Holder.Reference<Enchantment> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    @Override
    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.definition.requiredFeatures();
    }

    public record Cost(int base, int perLevel) {
        public int calculate(int level) {
            return this.base + this.perLevel * (level - 1);
        }
    }

    public record EnchantmentDefinition(TagKey<Item> supportedItems, Optional<TagKey<Item>> primaryItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, FeatureFlagSet requiredFeatures, EquipmentSlot[] slots) {
    }
}

