/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class WindBurstEnchantment
extends Enchantment {
    public WindBurstEnchantment() {
        super(Enchantment.definition(ItemTags.MACE_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, FeatureFlagSet.of(FeatureFlags.UPDATE_1_21), EquipmentSlot.MAINHAND));
    }

    @Override
    @Override
    public void doPostItemStackHurt(LivingEntity attacket, Entity target, int level) {
        float f = 0.25f + 0.25f * (float)level;
        attacket.level().explode(null, null, new WindBurstEnchantmentDamageCalculator(f), attacket.getX(), attacket.getY(), attacket.getZ(), 3.5f, false, Level.ExplosionInteraction.BLOW, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, SoundEvents.WIND_CHARGE_BURST);
    }

    @Override
    @Override
    public boolean isTradeable() {
        return false;
    }

    @Override
    @Override
    public boolean isDiscoverable() {
        return false;
    }

    static final class WindBurstEnchantmentDamageCalculator
    extends AbstractWindCharge.WindChargeDamageCalculator {
        private final float knockBackPower;

        public WindBurstEnchantmentDamageCalculator(float knockbackModifier) {
            this.knockBackPower = knockbackModifier;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Override
        public float getKnockbackMultiplier(Entity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.getAbilities().flying) {
                    return 0.0f;
                }
            }
            boolean bl = false;
            boolean bl2 = bl;
            if (bl2) return 0.0f;
            float f = this.knockBackPower;
            return f;
        }
    }
}

