/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class ExplosionDamageCalculator {
    public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return blockState.isAir() && fluidState.isEmpty() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(blockState.getBlock().getExplosionResistance(), fluidState.getExplosionResistance())));
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float power) {
        return true;
    }

    public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
        return true;
    }

    public float getKnockbackMultiplier(Entity entity) {
        return 1.0f;
    }

    @DoNotUse
    @Deprecated
    public float getEntityDamageAmount(Explosion explosion, Entity entity) {
        return this.getEntityDamageAmount(explosion, entity, Explosion.getSeenPercent(explosion.center(), entity));
    }

    public float getEntityDamageAmount(Explosion explosion, Entity entity, double seenPercent) {
        float f = explosion.radius() * 2.0f;
        Vec3 vec3 = explosion.center();
        double d = Math.sqrt(entity.distanceToSqr(vec3)) / (double)f;
        double e = (1.0 - d) * seenPercent;
        return (float)((e * e + e) / 2.0 * 7.0 * (double)f + 1.0);
    }
}

