/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;

public class BeehiveBlock
extends BaseEntityBlock {
    public static final MapCodec<BeehiveBlock> CODEC = BeehiveBlock.simpleCodec(BeehiveBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty HONEY_LEVEL = BlockStateProperties.LEVEL_HONEY;
    public static final int MAX_HONEY_LEVELS = 5;
    private static final int SHEARED_HONEYCOMB_COUNT = 3;

    public MapCodec<BeehiveBlock> codec() {
        return CODEC;
    }

    public BeehiveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(HONEY_LEVEL, 0)).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return state.getValue(HONEY_LEVEL);
    }

    @Override
    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool, includeDrops, dropExp);
        if (!world.isClientSide && blockEntity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)blockEntity;
            if (EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, tool) == 0) {
                tileentitybeehive.emptyAllLivingFromHive(player, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                world.updateNeighbourForOutputSignal(pos, this);
                this.angerNearbyBees(world, pos);
            }
        }
    }

    private void angerNearbyBees(Level world, BlockPos pos) {
        AABB axisalignedbb = new AABB(pos).inflate(8.0, 6.0, 8.0);
        List<Bee> list = world.getEntitiesOfClass(Bee.class, axisalignedbb);
        if (!list.isEmpty()) {
            List<Player> list1 = world.getEntitiesOfClass(Player.class, axisalignedbb);
            if (list1.isEmpty()) {
                return;
            }
            for (Bee entitybee : list) {
                if (entitybee.getTarget() != null) continue;
                Player entityhuman = Util.getRandom(list1, world.random);
                entitybee.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
            }
        }
    }

    public static void dropHoneycomb(Level world, BlockPos pos) {
        BeehiveBlock.popResource(world, pos, new net.minecraft.world.item.ItemStack(Items.HONEYCOMB, 3));
    }

    @Override
    protected ItemInteractionResult useItemOn(net.minecraft.world.item.ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = state.getValue(HONEY_LEVEL);
        boolean flag = false;
        if (i >= 5) {
            Item item = stack.getItem();
            if (stack.is(Items.SHEARS)) {
                PlayerShearBlockEvent event = new PlayerShearBlockEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos), (ItemStack)CraftItemStack.asCraftMirror(stack), CraftEquipmentSlot.getHand(hand), new ArrayList());
                event.getDrops().add(CraftItemStack.asCraftMirror(new net.minecraft.world.item.ItemStack(Items.HONEYCOMB, 3)));
                if (!event.callEvent()) {
                    return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                }
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (ItemStack itemDrop : event.getDrops()) {
                    BeehiveBlock.popResource(world, pos, CraftItemStack.asNMSCopy(itemDrop));
                }
                stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand(hand));
                flag = true;
                world.gameEvent((Entity)player, GameEvent.SHEAR, pos);
            } else if (stack.is(Items.GLASS_BOTTLE)) {
                stack.shrink(1);
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE));
                } else if (!player.getInventory().add(new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE))) {
                    player.drop(new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE), false);
                }
                flag = true;
                world.gameEvent((Entity)player, GameEvent.FLUID_PICKUP, pos);
            }
            if (!world.isClientSide() && flag) {
                player.awardStat(Stats.ITEM_USED.get(item));
            }
        }
        if (flag) {
            if (!CampfireBlock.isSmokeyPos(world, pos)) {
                if (this.hiveContainsBees(world, pos)) {
                    this.angerNearbyBees(world, pos);
                }
                this.releaseBeesAndResetHoneyLevel(world, state, pos, player, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            } else {
                this.resetHoneyLevel(world, state, pos);
            }
            return ItemInteractionResult.sidedSuccess(world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    private boolean hiveContainsBees(Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            return !tileentitybeehive.isEmpty();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(Level world, BlockState state, BlockPos pos, @Nullable Player player, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        this.resetHoneyLevel(world, state, pos);
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(player, state, beeState);
        }
    }

    public void resetHoneyLevel(Level world, BlockState state, BlockPos pos) {
        world.setBlock(pos, (BlockState)state.setValue(HONEY_LEVEL, 0), 3);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.getValue(HONEY_LEVEL) >= 5) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.trySpawnDripParticles(world, pos, state);
            }
        }
    }

    private void trySpawnDripParticles(Level world, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.getFluidState().isEmpty() && world.random.nextFloat() >= 0.3f && (d0 = (voxelshape = state.getCollisionShape(world, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.min(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(world, pos, voxelshape, (double)pos.getY() + d1 - 0.05);
            } else {
                BlockPos blockposition1 = pos.below();
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                VoxelShape voxelshape1 = iblockdata1.getCollisionShape(world, blockposition1);
                double d2 = voxelshape1.max(Direction.Axis.Y);
                if ((d2 < 1.0 || !iblockdata1.isCollisionShapeFullBlock(world, blockposition1)) && iblockdata1.getFluidState().isEmpty()) {
                    this.spawnParticle(world, pos, voxelshape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level world, BlockPos pos, VoxelShape shape, double height) {
        this.spawnFluidParticle(world, (double)pos.getX() + shape.min(Direction.Axis.X), (double)pos.getX() + shape.max(Direction.Axis.X), (double)pos.getZ() + shape.min(Direction.Axis.Z), (double)pos.getZ() + shape.max(Direction.Axis.Z), height);
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double height) {
        world.addParticle(ParticleTypes.DRIPPING_HONEY, Mth.lerp(world.random.nextDouble(), minX, maxX), height, Mth.lerp(world.random.nextDouble(), minZ, maxZ), 0.0, 0.0, 0.0);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(HONEY_LEVEL, FACING);
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BeehiveBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : BeehiveBlock.createTickerHelper(type, BlockEntityType.BEEHIVE, BeehiveBlockEntity::serverTick);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity;
        if (!world.isClientSide && player.isCreative() && world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (tileentity = world.getBlockEntity(pos)) instanceof BeehiveBlockEntity) {
            boolean flag;
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            int i = state.getValue(HONEY_LEVEL);
            boolean bl = flag = !tileentitybeehive.isEmpty();
            if (flag || i > 0) {
                net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(this);
                itemstack.applyComponents(tileentitybeehive.collectComponents());
                itemstack.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(HONEY_LEVEL, i));
                ItemEntity entityitem = new ItemEntity(world, pos.getX(), pos.getY(), pos.getZ(), itemstack);
                entityitem.setDefaultPickUpDelay();
                world.addFreshEntity(entityitem);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    protected List<net.minecraft.world.item.ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity tileentity;
        Entity entity = builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (tileentity = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.getDrops(state, builder);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockEntity tileentity;
        if (world.getBlockState(neighborPos).getBlock() instanceof FireBlock && (tileentity = world.getBlockEntity(pos)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity tileentitybeehive = (BeehiveBlockEntity)tileentity;
            tileentitybeehive.emptyAllLivingFromHive(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, rotation.rotate(state.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(FACING)));
    }
}

