/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class BellBlock
extends BaseEntityBlock {
    public static final MapCodec<BellBlock> CODEC = BellBlock.simpleCodec(BellBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.BELL_ATTACHMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.box(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.box(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.box(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.or(BELL_BOTTOM_SHAPE, BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_WEST = Shapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape TO_EAST = Shapes.or(BELL_SHAPE, Block.box(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_NORTH = Shapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape TO_SOUTH = Shapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int EVENT_BELL_RING = 1;

    public MapCodec<BellBlock> codec() {
        return CODEC;
    }

    public BellBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(FACING, Direction.NORTH)).setValue(ATTACHMENT, BellAttachType.FLOOR)).setValue(POWERED, false));
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean flag1 = world.hasNeighborSignal(pos);
        if (flag1 != state.getValue(POWERED)) {
            if (flag1) {
                this.attemptToRing(world, pos, null);
            }
            world.setBlock(pos, (BlockState)state.setValue(POWERED, flag1), 3);
        }
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.getOwner();
        Player entityhuman = entity instanceof Player ? (Player)entity : null;
        this.onHit(world, state, hit, entityhuman, true);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return this.onHit(world, state, hit, player, true) ? InteractionResult.sidedSuccess(world.isClientSide) : InteractionResult.PASS;
    }

    public boolean onHit(Level world, BlockState state, BlockHitResult hitResult, @Nullable Player player, boolean checkHitPos) {
        boolean flag1;
        Direction enumdirection = hitResult.getDirection();
        BlockPos blockposition = hitResult.getBlockPos();
        boolean bl = flag1 = !checkHitPos || this.isProperHit(state, enumdirection, hitResult.getLocation().y - (double)blockposition.getY());
        if (flag1) {
            boolean flag2 = this.attemptToRing(player, world, blockposition, enumdirection);
            if (flag2 && player != null) {
                player.awardStat(Stats.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState state, Direction side, double y) {
        if (side.getAxis() != Direction.Axis.Y && y <= (double)0.8124f) {
            Direction enumdirection1 = state.getValue(FACING);
            BellAttachType blockpropertybellattach = state.getValue(ATTACHMENT);
            switch (blockpropertybellattach) {
                case FLOOR: {
                    return enumdirection1.getAxis() == side.getAxis();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return enumdirection1.getAxis() != side.getAxis();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean attemptToRing(Level world, BlockPos pos, @Nullable Direction direction) {
        return this.attemptToRing(null, world, pos, direction);
    }

    public boolean attemptToRing(@Nullable Entity entity, Level world, BlockPos pos, @Nullable Direction direction) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (!world.isClientSide && tileentity instanceof BellBlockEntity) {
            if (direction == null) {
                direction = world.getBlockState(pos).getValue(FACING);
            }
            if (!CraftEventFactory.handleBellRingEvent(world, pos, direction, entity)) {
                return false;
            }
            ((BellBlockEntity)tileentity).onHit(direction);
            world.playSound((Player)null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
            world.gameEvent(entity, GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState state) {
        Direction enumdirection = state.getValue(FACING);
        BellAttachType blockpropertybellattach = state.getValue(ATTACHMENT);
        return blockpropertybellattach == BellAttachType.FLOOR ? (enumdirection != Direction.NORTH && enumdirection != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE) : (blockpropertybellattach == BellAttachType.CEILING ? CEILING_SHAPE : (blockpropertybellattach == BellAttachType.DOUBLE_WALL ? (enumdirection != Direction.NORTH && enumdirection != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN) : (enumdirection == Direction.NORTH ? TO_NORTH : (enumdirection == Direction.SOUTH ? TO_SOUTH : (enumdirection == Direction.EAST ? TO_EAST : TO_WEST)))));
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction enumdirection = ctx.getClickedFace();
        BlockPos blockposition = ctx.getClickedPos();
        Level world = ctx.getLevel();
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        if (enumdirection_enumaxis == Direction.Axis.Y) {
            BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, enumdirection == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR)).setValue(FACING, ctx.getHorizontalDirection());
            if (iblockdata.canSurvive(ctx.getLevel(), blockposition)) {
                return iblockdata;
            }
        } else {
            boolean flag = enumdirection_enumaxis == Direction.Axis.X && world.getBlockState(blockposition.west()).isFaceSturdy(world, blockposition.west(), Direction.EAST) && world.getBlockState(blockposition.east()).isFaceSturdy(world, blockposition.east(), Direction.WEST) || enumdirection_enumaxis == Direction.Axis.Z && world.getBlockState(blockposition.north()).isFaceSturdy(world, blockposition.north(), Direction.SOUTH) && world.getBlockState(blockposition.south()).isFaceSturdy(world, blockposition.south(), Direction.NORTH);
            BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, enumdirection.getOpposite())).setValue(ATTACHMENT, flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL);
            if (iblockdata.canSurvive(ctx.getLevel(), ctx.getClickedPos())) {
                return iblockdata;
            }
            boolean flag1 = world.getBlockState(blockposition.below()).isFaceSturdy(world, blockposition.below(), Direction.UP);
            if ((iblockdata = (BlockState)iblockdata.setValue(ATTACHMENT, flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING)).canSurvive(ctx.getLevel(), ctx.getClickedPos())) {
                return iblockdata;
            }
        }
        return null;
    }

    @Override
    protected void onExplosionHit(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        if (explosion.getBlockInteraction() == Explosion.BlockInteraction.TRIGGER_BLOCK && !world.isClientSide()) {
            this.attemptToRing(world, pos, null);
        }
        super.onExplosionHit(state, world, pos, explosion, stackMerger);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BellAttachType blockpropertybellattach = state.getValue(ATTACHMENT);
        Direction enumdirection1 = BellBlock.getConnectedDirection(state).getOpposite();
        if (enumdirection1 == direction && !state.canSurvive(world, pos) && blockpropertybellattach != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction.getAxis() == state.getValue(FACING).getAxis()) {
            if (blockpropertybellattach == BellAttachType.DOUBLE_WALL && !neighborState.isFaceSturdy(world, neighborPos, direction)) {
                return (BlockState)((BlockState)state.setValue(ATTACHMENT, BellAttachType.SINGLE_WALL)).setValue(FACING, direction.getOpposite());
            }
            if (blockpropertybellattach == BellAttachType.SINGLE_WALL && enumdirection1.getOpposite() == direction && neighborState.isFaceSturdy(world, neighborPos, state.getValue(FACING))) {
                return (BlockState)state.setValue(ATTACHMENT, BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction enumdirection = BellBlock.getConnectedDirection(state).getOpposite();
        return enumdirection == Direction.UP ? Block.canSupportCenter(world, pos.above(), Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.canAttach(world, pos, enumdirection);
    }

    private static Direction getConnectedDirection(BlockState state) {
        switch (state.getValue(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return state.getValue(FACING).getOpposite();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FACING, ATTACHMENT, POWERED);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BellBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BellBlock.createTickerHelper(type, BlockEntityType.BELL, world.isClientSide ? BellBlockEntity::clientTick : BellBlockEntity::serverTick);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, rotation.rotate(state.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(FACING)));
    }
}

