/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class ChorusPlantBlock
extends PipeBlock {
    public static final MapCodec<ChorusPlantBlock> CODEC = ChorusPlantBlock.simpleCodec(ChorusPlantBlock::new);

    public MapCodec<ChorusPlantBlock> codec() {
        return CODEC;
    }

    protected ChorusPlantBlock(BlockBehaviour.Properties settings) {
        super(0.3125f, settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(PipeBlock.NORTH, false)).setValue(PipeBlock.EAST, false)).setValue(PipeBlock.SOUTH, false)).setValue(PipeBlock.WEST, false)).setValue(PipeBlock.UP, false)).setValue(PipeBlock.DOWN, false));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return this.defaultBlockState();
        }
        return ChorusPlantBlock.getStateWithConnections(ctx.getLevel(), ctx.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState blockState = world.getBlockState(pos.below());
        BlockState blockState2 = world.getBlockState(pos.above());
        BlockState blockState3 = world.getBlockState(pos.north());
        BlockState blockState4 = world.getBlockState(pos.east());
        BlockState blockState5 = world.getBlockState(pos.south());
        BlockState blockState6 = world.getBlockState(pos.west());
        Block block = state.getBlock();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.trySetValue(PipeBlock.DOWN, blockState.is(block) || blockState.is(Blocks.CHORUS_FLOWER) || blockState.is(Blocks.END_STONE))).trySetValue(PipeBlock.UP, blockState2.is(block) || blockState2.is(Blocks.CHORUS_FLOWER))).trySetValue(PipeBlock.NORTH, blockState3.is(block) || blockState3.is(Blocks.CHORUS_FLOWER))).trySetValue(PipeBlock.EAST, blockState4.is(block) || blockState4.is(Blocks.CHORUS_FLOWER))).trySetValue(PipeBlock.SOUTH, blockState5.is(block) || blockState5.is(Blocks.CHORUS_FLOWER))).trySetValue(PipeBlock.WEST, blockState6.is(block) || blockState6.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return state;
        }
        if (!state.canSurvive(world, pos)) {
            world.scheduleTick(pos, this, 1);
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        boolean bl = neighborState.is(this) || neighborState.is(Blocks.CHORUS_FLOWER) || direction == Direction.DOWN && neighborState.is(Blocks.END_STONE);
        return (BlockState)state.setValue(PipeBlock.PROPERTY_BY_DIRECTION.get(direction), bl);
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return;
        }
        if (!state.canSurvive(world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (GlobalConfiguration.get().blockUpdates.disableChorusPlantUpdates) {
            return true;
        }
        BlockState blockState = world.getBlockState(pos.below());
        boolean bl = !world.getBlockState(pos.above()).isAir() && !blockState.isAir();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState2 = world.getBlockState(blockPos);
            if (!blockState2.is(this)) continue;
            if (bl) {
                return false;
            }
            BlockState blockState3 = world.getBlockState(blockPos.below());
            if (!blockState3.is(this) && !blockState3.is(Blocks.END_STONE)) continue;
            return true;
        }
        return blockState.is(this) || blockState.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(PipeBlock.NORTH, PipeBlock.EAST, PipeBlock.SOUTH, PipeBlock.WEST, PipeBlock.UP, PipeBlock.DOWN);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

