/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public abstract class GrowingPlantHeadBlock
extends GrowingPlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected GrowingPlantHeadBlock(BlockBehaviour.Properties settings, Direction growthDirection, VoxelShape outlineShape, boolean tickWater, double growthChance) {
        super(settings, growthDirection, outlineShape, tickWater);
        this.growPerTickProbability = growthChance;
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(AGE, 0));
    }

    protected abstract MapCodec<? extends GrowingPlantHeadBlock> codec();

    @Override
    public BlockState getStateForPlacement(LevelAccessor world) {
        return (BlockState)this.defaultBlockState().setValue(AGE, world.getRandom().nextInt(this.getMaxGrowthAge()));
    }

    @Override
    protected boolean isRandomlyTicking(BlockState state) {
        return state.getValue(AGE) < this.getMaxGrowthAge();
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockposition1;
        int modifier = this == Blocks.KELP ? world.spigotConfig.kelpModifier : (this == Blocks.TWISTING_VINES ? world.spigotConfig.twistingVinesModifier : (this == Blocks.WEEPING_VINES ? world.spigotConfig.weepingVinesModifier : world.spigotConfig.caveVinesModifier));
        if (state.getValue(AGE) < this.getMaxGrowthAge() && random.nextDouble() < (double)modifier / 100.0 * this.growPerTickProbability && this.canGrowInto(world.getBlockState(blockposition1 = pos.relative(this.growthDirection)))) {
            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, this.getGrowIntoState(state, world.random, world));
        }
    }

    protected BlockState getGrowIntoState(BlockState state, RandomSource random, @Nullable Level level) {
        return this.getGrowIntoState(state, random);
    }

    protected BlockState getGrowIntoState(BlockState state, RandomSource random) {
        return (BlockState)state.cycle(AGE);
    }

    public BlockState getMaxAgeState(BlockState state) {
        return (BlockState)state.setValue(AGE, this.getMaxGrowthAge());
    }

    public boolean isMaxAge(BlockState state) {
        return state.getValue(AGE) >= this.getMaxGrowthAge();
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState from, BlockState to) {
        return to;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.growthDirection.getOpposite() && !state.canSurvive(world, pos)) {
            world.scheduleTick(pos, this, 1);
        }
        if (direction == this.growthDirection && (neighborState.is(this) || neighborState.is(this.getBodyBlock()))) {
            return this.updateBodyAfterConvertedFromHead(state, this.getBodyBlock().defaultBlockState());
        }
        if (this.scheduleFluidTicks) {
            world.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return this.canGrowInto(world.getBlockState(pos.relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockposition1 = pos.relative(this.growthDirection);
        int i = Math.min(state.getValue(AGE) + 1, this.getMaxGrowthAge());
        int j = this.getBlocksToGrowWhenBonemealed(random);
        for (int k = 0; k < j && this.canGrowInto(world.getBlockState(blockposition1)); ++k) {
            world.setBlockAndUpdate(blockposition1, (BlockState)state.setValue(AGE, i));
            blockposition1 = blockposition1.relative(this.growthDirection);
            i = Math.min(i + 1, this.getMaxGrowthAge());
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected GrowingPlantHeadBlock getHeadBlock() {
        return this;
    }

    public abstract int getMaxGrowthAge();
}

