/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class ObserverBlock
extends DirectionalBlock {
    public static final MapCodec<ObserverBlock> CODEC = ObserverBlock.simpleCodec(ObserverBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<ObserverBlock> codec() {
        return CODEC;
    }

    public ObserverBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(DirectionalBlock.FACING, Direction.SOUTH)).setValue(POWERED, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(DirectionalBlock.FACING, POWERED);
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(DirectionalBlock.FACING, rotation.rotate(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (state.getValue(POWERED).booleanValue()) {
            if (CraftEventFactory.callRedstoneChange(world, pos, 15, 0).getNewCurrent() != 0) {
                return;
            }
            world.setBlock(pos, (BlockState)state.setValue(POWERED, false), 2);
        } else {
            if (CraftEventFactory.callRedstoneChange(world, pos, 0, 15).getNewCurrent() != 15) {
                return;
            }
            world.setBlock(pos, (BlockState)state.setValue(POWERED, true), 2);
            world.scheduleTick(pos, this, 2);
        }
        this.updateNeighborsInFront(world, pos, state);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!(state.getValue(DirectionalBlock.FACING) != direction || state.getValue(POWERED).booleanValue() || world.getMinecraftWorld().purpurConfig.disableObserverClocks && neighborState.getBlock() instanceof ObserverBlock && neighborState.getValue(DirectionalBlock.FACING).getOpposite() == direction)) {
            this.startSignal(world, pos);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    private void startSignal(LevelAccessor world, BlockPos pos) {
        if (!world.isClientSide() && !world.getBlockTicks().hasScheduledTick(pos, this)) {
            world.scheduleTick(pos, this, 2);
        }
    }

    protected void updateNeighborsInFront(Level world, BlockPos pos, BlockState state) {
        Direction enumdirection = state.getValue(DirectionalBlock.FACING);
        BlockPos blockposition1 = pos.relative(enumdirection.getOpposite());
        world.neighborChanged(blockposition1, this, pos);
        world.updateNeighborsAtExceptFromFacing(blockposition1, this, enumdirection);
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getSignal(world, pos, direction);
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false && state.getValue(DirectionalBlock.FACING) == direction ? 15 : 0;
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(oldState.getBlock()) && !world.isClientSide() && state.getValue(POWERED).booleanValue() && !world.getBlockTicks().hasScheduledTick(pos, this)) {
            BlockState iblockdata2 = (BlockState)state.setValue(POWERED, false);
            world.setBlock(pos, iblockdata2, 18);
            this.updateNeighborsInFront(world, pos, iblockdata2);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock()) && !world.isClientSide && state.getValue(POWERED).booleanValue() && world.getBlockTicks().hasScheduledTick(pos, this)) {
            this.updateNeighborsInFront(world, pos, (BlockState)state.setValue(POWERED, false));
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, ctx.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

