/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    public final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    public LivingEntity destroyTarget;
    @Nullable
    public UUID destroyTargetUUID;
    private long nextAmbientSoundActivation;

    public ConduitBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.CONDUIT, pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.destroyTargetUUID = nbt.hasUUID("Target") ? nbt.getUUID("Target") : null;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.destroyTarget != null) {
            nbt.putUUID("Target", this.destroyTarget.getUUID());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveCustomOnly(registryLookup);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, ConduitBlockEntity blockEntity) {
        ++blockEntity.tickCount;
        long i = world.getGameTime();
        List<BlockPos> list = blockEntity.effectBlocks;
        if (i % 40L == 0L) {
            blockEntity.isActive = ConduitBlockEntity.updateShape(world, pos, list);
            ConduitBlockEntity.updateHunting(blockEntity, list);
        }
        ConduitBlockEntity.updateClientTarget(world, pos, blockEntity);
        ConduitBlockEntity.animationTick(world, pos, list, blockEntity.destroyTarget, blockEntity.tickCount);
        if (blockEntity.isActive()) {
            blockEntity.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, ConduitBlockEntity blockEntity) {
        ++blockEntity.tickCount;
        long i = world.getGameTime();
        List<BlockPos> list = blockEntity.effectBlocks;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntity.updateShape(world, pos, list);
            if (flag != blockEntity.isActive) {
                SoundEvent soundeffect = flag ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                world.playSound((Player)null, pos, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.isActive = flag;
            ConduitBlockEntity.updateHunting(blockEntity, list);
            if (flag) {
                ConduitBlockEntity.applyEffects(world, pos, list);
                ConduitBlockEntity.updateDestroyTarget(world, pos, state, list, blockEntity);
            }
        }
        if (blockEntity.isActive()) {
            if (i % 80L == 0L) {
                world.playSound((Player)null, pos, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > blockEntity.nextAmbientSoundActivation) {
                blockEntity.nextAmbientSoundActivation = i + 60L + (long)world.getRandom().nextInt(40);
                world.playSound((Player)null, pos, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(ConduitBlockEntity blockEntity, List<BlockPos> activatingBlocks) {
        blockEntity.setHunting(activatingBlocks.size() >= 42);
    }

    private static boolean updateShape(Level world, BlockPos pos, List<BlockPos> activatingBlocks) {
        int k;
        int j;
        int i;
        activatingBlocks.clear();
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (k = -1; k <= 1; ++k) {
                    BlockPos blockposition1 = pos.offset(i, j, k);
                    if (world.isWaterAt(blockposition1)) continue;
                    return false;
                }
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (k = -2; k <= 2; ++k) {
                    int l = Math.abs(i);
                    int i1 = Math.abs(j);
                    int j1 = Math.abs(k);
                    if (l <= 1 && i1 <= 1 && j1 <= 1 || (i != 0 || i1 != 2 && j1 != 2) && (j != 0 || l != 2 && j1 != 2) && (k != 0 || l != 2 && i1 != 2)) continue;
                    BlockPos blockposition2 = pos.offset(i, j, k);
                    BlockState iblockdata = world.getBlockState(blockposition2);
                    for (Block block : world.purpurConfig.conduitBlocks) {
                        if (!iblockdata.is(block)) continue;
                        activatingBlocks.add(blockposition2);
                    }
                }
            }
        }
        return activatingBlocks.size() >= 16;
    }

    private static void applyEffects(Level world, BlockPos pos, List<BlockPos> activatingBlocks) {
        ConduitBlockEntity.applyEffects(world, pos, ConduitBlockEntity.getRange(activatingBlocks, world));
    }

    public static int getRange(List<BlockPos> list, Level world) {
        int i = list.size();
        int j = i / 7 * world.purpurConfig.conduitDistance;
        return j;
    }

    private static void applyEffects(Level world, BlockPos blockposition, int j) {
        int i1;
        int l;
        int k = blockposition.getX();
        AABB axisalignedbb = new AABB(k, l = blockposition.getY(), i1 = blockposition.getZ(), k + 1, l + 1, i1 + 1).inflate(j).expandTowards(0.0, world.getHeight(), 0.0);
        List<Player> list1 = world.getEntitiesOfClass(Player.class, axisalignedbb);
        if (!list1.isEmpty()) {
            for (Player entityhuman : list1) {
                if (!blockposition.closerThan(entityhuman.blockPosition(), j) || !entityhuman.isInWaterOrRain()) continue;
                entityhuman.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true), EntityPotionEffectEvent.Cause.CONDUIT);
            }
        }
    }

    private static void updateDestroyTarget(Level world, BlockPos pos, BlockState state, List<BlockPos> activatingBlocks, ConduitBlockEntity blockEntity) {
        ConduitBlockEntity.updateDestroyTarget(world, pos, state, activatingBlocks, blockEntity, true);
    }

    public static void updateDestroyTarget(Level world, BlockPos blockposition, BlockState iblockdata, List<BlockPos> list, ConduitBlockEntity tileentityconduit, boolean damageTarget) {
        LivingEntity entityliving = tileentityconduit.destroyTarget;
        int i = list.size();
        if (i < 42) {
            tileentityconduit.destroyTarget = null;
        } else if (tileentityconduit.destroyTarget == null && tileentityconduit.destroyTargetUUID != null) {
            tileentityconduit.destroyTarget = ConduitBlockEntity.findDestroyTarget(world, blockposition, tileentityconduit.destroyTargetUUID);
            tileentityconduit.destroyTargetUUID = null;
        } else if (tileentityconduit.destroyTarget == null) {
            List<LivingEntity> list1 = world.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(blockposition, world), entityliving1 -> entityliving1 instanceof Enemy && entityliving1.isInWaterOrRain());
            if (!list1.isEmpty()) {
                tileentityconduit.destroyTarget = list1.get(world.random.nextInt(list1.size()));
            }
        } else if (!tileentityconduit.destroyTarget.isAlive() || !blockposition.closerThan(tileentityconduit.destroyTarget.blockPosition(), world.purpurConfig.conduitDamageDistance)) {
            tileentityconduit.destroyTarget = null;
        }
        if (damageTarget && tileentityconduit.destroyTarget != null && tileentityconduit.destroyTarget.hurt(world.damageSources().magic().directBlock(world, blockposition), world.purpurConfig.conduitDamageAmount)) {
            world.playSound(null, tileentityconduit.destroyTarget.getX(), tileentityconduit.destroyTarget.getY(), tileentityconduit.destroyTarget.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (entityliving != tileentityconduit.destroyTarget) {
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 2);
        }
    }

    private static void updateClientTarget(Level world, BlockPos pos, ConduitBlockEntity blockEntity) {
        if (blockEntity.destroyTargetUUID == null) {
            blockEntity.destroyTarget = null;
        } else if (blockEntity.destroyTarget == null || !blockEntity.destroyTarget.getUUID().equals(blockEntity.destroyTargetUUID)) {
            blockEntity.destroyTarget = ConduitBlockEntity.findDestroyTarget(world, pos, blockEntity.destroyTargetUUID);
            if (blockEntity.destroyTarget == null) {
                blockEntity.destroyTargetUUID = null;
            }
        }
    }

    public static AABB getDestroyRangeAABB(BlockPos pos) {
        return ConduitBlockEntity.getDestroyRangeAABB(pos, null);
    }

    private static AABB getDestroyRangeAABB(BlockPos pos, Level level) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        return new AABB(i, j, k, i + 1, j + 1, k + 1).inflate(level == null ? 8.0 : level.purpurConfig.conduitDamageDistance);
    }

    @Nullable
    private static LivingEntity findDestroyTarget(Level world, BlockPos pos, UUID uuid) {
        List<LivingEntity> list = world.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(pos, world), entityliving -> entityliving.getUUID().equals(uuid));
        return list.size() == 1 ? list.get(0) : null;
    }

    private static void animationTick(Level world, BlockPos pos, List<BlockPos> activatingBlocks, @Nullable Entity entity, int ticks) {
        float f;
        RandomSource randomsource = world.random;
        double d0 = Mth.sin((float)(ticks + 35) * 0.1f) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3d = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.5 + d0, (double)pos.getZ() + 0.5);
        for (BlockPos blockposition1 : activatingBlocks) {
            if (randomsource.nextInt(50) != 0) continue;
            BlockPos blockposition2 = blockposition1.subtract(pos);
            f = -0.5f + randomsource.nextFloat() + (float)blockposition2.getX();
            float f1 = -2.0f + randomsource.nextFloat() + (float)blockposition2.getY();
            float f2 = -0.5f + randomsource.nextFloat() + (float)blockposition2.getZ();
            world.addParticle(ParticleTypes.NAUTILUS, vec3d.x, vec3d.y, vec3d.z, f, f1, f2);
        }
        if (entity != null) {
            Vec3 vec3d1 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
            float f3 = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            float f4 = -1.0f + randomsource.nextFloat() * entity.getBbHeight();
            f = (-0.5f + randomsource.nextFloat()) * (3.0f + entity.getBbWidth());
            Vec3 vec3d2 = new Vec3(f3, f4, f);
            world.addParticle(ParticleTypes.NAUTILUS, vec3d1.x, vec3d1.y, vec3d1.z, vec3d2.x, vec3d2.y, vec3d2.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean eyeOpen) {
        this.isHunting = eyeOpen;
    }

    public float getActiveRotation(float tickDelta) {
        return (this.activeRotation + tickDelta) * -0.0375f;
    }
}

