/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.purpurmc.purpur.event.entity.EntityTeleportHinderedEvent;
import org.slf4j.Logger;

public class TheEndGatewayBlockEntity
extends TheEndPortalBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SPAWN_TIME = 200;
    private static final int COOLDOWN_TIME = 40;
    private static final int ATTENTION_INTERVAL = 2400;
    private static final int EVENT_COOLDOWN = 1;
    private static final int GATEWAY_HEIGHT_ABOVE_SURFACE = 10;
    public long age;
    private int teleportCooldown;
    @Nullable
    public BlockPos exitPortal;
    public boolean exactTeleport;

    public TheEndGatewayBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.END_GATEWAY, pos, state);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putLong("Age", this.age);
        if (this.exitPortal != null) {
            nbt.put("exit_portal", NbtUtils.writeBlockPos(this.exitPortal));
        }
        if (this.exactTeleport) {
            nbt.putBoolean("ExactTeleport", true);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.age = nbt.getLong("Age");
        NbtUtils.readBlockPos(nbt, "exit_portal").filter(Level::isInSpawnableBounds).ifPresent(blockposition -> {
            this.exitPortal = blockposition;
        });
        this.exactTeleport = nbt.getBoolean("ExactTeleport");
    }

    public static void beamAnimationTick(Level world, BlockPos pos, BlockState state, TheEndGatewayBlockEntity blockEntity) {
        ++blockEntity.age;
        if (blockEntity.isCoolingDown()) {
            --blockEntity.teleportCooldown;
        }
    }

    public static void teleportTick(Level world, BlockPos pos, BlockState state, TheEndGatewayBlockEntity blockEntity) {
        boolean flag = blockEntity.isSpawning();
        boolean flag1 = blockEntity.isCoolingDown();
        ++blockEntity.age;
        if (flag1) {
            --blockEntity.teleportCooldown;
        } else {
            List<net.minecraft.world.entity.Entity> list = world.getEntitiesOfClass(net.minecraft.world.entity.Entity.class, new AABB(pos), TheEndGatewayBlockEntity::canEntityTeleport);
            if (!list.isEmpty()) {
                TheEndGatewayBlockEntity.teleportEntity(world, pos, state, list.get(world.random.nextInt(list.size())), blockEntity);
            }
            if (blockEntity.age % 2400L == 0L) {
                TheEndGatewayBlockEntity.triggerCooldown(world, pos, state, blockEntity);
            }
        }
        if (flag != blockEntity.isSpawning() || flag1 != blockEntity.isCoolingDown()) {
            TheEndGatewayBlockEntity.setChanged(world, pos, state);
        }
    }

    public static boolean canEntityTeleport(net.minecraft.world.entity.Entity entity) {
        return EntitySelector.NO_SPECTATORS.test(entity) && !entity.getRootVehicle().isOnPortalCooldown();
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent(float tickDelta) {
        return Mth.clamp(((float)this.age + tickDelta) / 200.0f, 0.0f, 1.0f);
    }

    public float getCooldownPercent(float tickDelta) {
        return 1.0f - Mth.clamp(((float)this.teleportCooldown - tickDelta) / 40.0f, 0.0f, 1.0f);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveCustomOnly(registryLookup);
    }

    private static void triggerCooldown(Level world, BlockPos pos, BlockState state, TheEndGatewayBlockEntity blockEntity) {
        if (!world.isClientSide) {
            blockEntity.teleportCooldown = 40;
            world.blockEvent(pos, state.getBlock(), 1, 0);
            TheEndGatewayBlockEntity.setChanged(world, pos, state);
        }
    }

    @Override
    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.triggerEvent(type, data);
    }

    public static void teleportEntity(Level world, BlockPos pos, BlockState state, net.minecraft.world.entity.Entity entity, TheEndGatewayBlockEntity blockEntity) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!blockEntity.isCoolingDown()) {
                BlockPos blockposition1;
                if (!entity.canChangeDimensions()) {
                    return;
                }
                if (world.purpurConfig.imposeTeleportRestrictionsOnGateways && (entity.isVehicle() || entity.isPassenger())) {
                    if (new EntityTeleportHinderedEvent((Entity)entity.getBukkitEntity(), entity.isPassenger() ? EntityTeleportHinderedEvent.Reason.IS_PASSENGER : EntityTeleportHinderedEvent.Reason.IS_VEHICLE, PlayerTeleportEvent.TeleportCause.END_GATEWAY).callEvent()) {
                        TheEndGatewayBlockEntity.teleportEntity(world, pos, state, entity, blockEntity);
                    }
                    return;
                }
                blockEntity.teleportCooldown = 100;
                if (blockEntity.exitPortal == null && world.getTypeKey() == LevelStem.END) {
                    blockposition1 = TheEndGatewayBlockEntity.findOrCreateValidTeleportPos(worldserver, pos);
                    blockposition1 = blockposition1.above(10);
                    LOGGER.debug("Creating portal at {}", (Object)blockposition1);
                    TheEndGatewayBlockEntity.spawnGatewayPortal(worldserver, blockposition1, EndGatewayConfiguration.knownExit(pos, false));
                    blockEntity.exitPortal = blockposition1;
                }
                if (blockEntity.exitPortal != null) {
                    net.minecraft.world.entity.Entity entity1;
                    BlockPos blockPos = blockposition1 = blockEntity.exactTeleport ? blockEntity.exitPortal : TheEndGatewayBlockEntity.findExitPosition(world, blockEntity.exitPortal);
                    if (entity instanceof ThrownEnderpearl) {
                        net.minecraft.world.entity.Entity entity2 = ((ThrownEnderpearl)entity).getOwner();
                        if (entity2 instanceof ServerPlayer) {
                            CriteriaTriggers.ENTER_BLOCK.trigger((ServerPlayer)entity2, state);
                        }
                        if (entity2 != null) {
                            entity1 = entity2;
                            entity.discard(EntityRemoveEvent.Cause.HIT);
                        } else {
                            entity1 = entity;
                        }
                    } else {
                        entity1 = entity.getRootVehicle();
                    }
                    if (entity1 instanceof ServerPlayer) {
                        CraftPlayer player = (CraftPlayer)entity1.getBukkitEntity();
                        Location location = CraftLocation.toBukkit(blockposition1, (World)world.getWorld()).add(0.5, 0.0, 0.5);
                        location.setPitch(player.getLocation().getPitch());
                        location.setYaw(player.getLocation().getYaw());
                        PlayerTeleportEndGatewayEvent teleEvent = new PlayerTeleportEndGatewayEvent((Player)player, player.getLocation(), location, (EndGateway)new CraftEndGateway((World)worldserver.getWorld(), blockEntity));
                        Bukkit.getPluginManager().callEvent((Event)teleEvent);
                        if (teleEvent.isCancelled()) {
                            return;
                        }
                        entity1.setPortalCooldown();
                        ((ServerPlayer)entity1).connection.teleport(teleEvent.getTo());
                        entity1.teleportPassengers();
                        TheEndGatewayBlockEntity.triggerCooldown(world, pos, state, blockEntity);
                        return;
                    }
                    Location location = new Location((World)world.getWorld(), (double)blockposition1.getX() + 0.5, (double)blockposition1.getY(), (double)blockposition1.getZ() + 0.5);
                    location.setPitch(entity1.getXRot());
                    location.setYaw(entity1.getBukkitYaw());
                    CraftEntity bukkitEntity = entity1.getBukkitEntity();
                    EntityTeleportEndGatewayEvent teleEvent = new EntityTeleportEndGatewayEvent((Entity)bukkitEntity, bukkitEntity.getLocation(), location, (EndGateway)new CraftEndGateway((World)world.getWorld(), blockEntity));
                    if (!teleEvent.callEvent() || teleEvent.getTo() == null) {
                        return;
                    }
                    entity1.setPortalCooldown();
                    entity1.teleportToWithTicket(teleEvent.getTo().getX(), teleEvent.getTo().getY(), teleEvent.getTo().getZ());
                }
                TheEndGatewayBlockEntity.triggerCooldown(world, pos, state, blockEntity);
            }
        }
    }

    private static BlockPos findExitPosition(Level world, BlockPos pos) {
        BlockPos blockposition1 = TheEndGatewayBlockEntity.findTallestBlock(world, pos.offset(0, 2, 0), 5, false);
        LOGGER.debug("Best exit position for portal at {} is {}", (Object)pos, (Object)blockposition1);
        return blockposition1.above();
    }

    private static BlockPos findOrCreateValidTeleportPos(ServerLevel world, BlockPos pos) {
        Vec3 vec3d = TheEndGatewayBlockEntity.findExitPortalXZPosTentative(world, pos);
        LevelChunk chunk = TheEndGatewayBlockEntity.getChunk(world, vec3d);
        BlockPos blockposition1 = TheEndGatewayBlockEntity.findValidSpawnInChunk(chunk);
        if (blockposition1 == null) {
            BlockPos blockposition2 = BlockPos.containing(vec3d.x + 0.5, 75.0, vec3d.z + 0.5);
            LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            world.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.getHolder(EndFeatures.END_ISLAND)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(world, world.getChunkSource().getGenerator(), RandomSource.create(blockposition2.asLong()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            LOGGER.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TheEndGatewayBlockEntity.findTallestBlock(world, blockposition1, 16, true);
    }

    private static Vec3 findExitPortalXZPosTentative(ServerLevel world, BlockPos pos) {
        Vec3 vec3d = new Vec3(pos.getX(), 0.0, pos.getZ()).normalize();
        boolean flag = true;
        Vec3 vec3d1 = vec3d.scale(1024.0);
        int i = 16;
        while (!TheEndGatewayBlockEntity.isChunkEmpty(world, vec3d1) && i-- > 0) {
            LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(-16.0));
        }
        i = 16;
        while (TheEndGatewayBlockEntity.isChunkEmpty(world, vec3d1) && i-- > 0) {
            LOGGER.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(16.0));
        }
        LOGGER.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean isChunkEmpty(ServerLevel world, Vec3 pos) {
        return TheEndGatewayBlockEntity.getChunk(world, pos).getHighestFilledSectionIndex() == -1;
    }

    private static BlockPos findTallestBlock(BlockGetter world, BlockPos pos, int searchRadius, boolean force) {
        Vec3i blockposition1 = null;
        for (int j = -searchRadius; j <= searchRadius; ++j) {
            block1: for (int k = -searchRadius; k <= searchRadius; ++k) {
                if (j == 0 && k == 0 && !force) continue;
                for (int l = world.getMaxBuildHeight() - 1; l > (blockposition1 == null ? world.getMinBuildHeight() : blockposition1.getY()); --l) {
                    BlockPos blockposition2 = new BlockPos(pos.getX() + j, l, pos.getZ() + k);
                    BlockState iblockdata = world.getBlockState(blockposition2);
                    if (!iblockdata.isCollisionShapeFullBlock(world, blockposition2) || !force && iblockdata.is(Blocks.BEDROCK)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? pos : blockposition1;
    }

    private static LevelChunk getChunk(Level world, Vec3 pos) {
        return world.getChunk(Mth.floor(pos.x / 16.0), Mth.floor(pos.z / 16.0));
    }

    @Nullable
    private static BlockPos findValidSpawnInChunk(LevelChunk chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        BlockPos blockposition = new BlockPos(chunkcoordintpair.getMinBlockX(), 30, chunkcoordintpair.getMinBlockZ());
        int i = chunk.getHighestSectionPosition() + 16 - 1;
        BlockPos blockposition1 = new BlockPos(chunkcoordintpair.getMaxBlockX(), i, chunkcoordintpair.getMaxBlockZ());
        BlockPos blockposition2 = null;
        double d0 = 0.0;
        for (BlockPos blockposition3 : BlockPos.betweenClosed(blockposition, blockposition1)) {
            BlockState iblockdata = chunk.getBlockState(blockposition3);
            BlockPos blockposition4 = blockposition3.above();
            BlockPos blockposition5 = blockposition3.above(2);
            if (!iblockdata.is(Blocks.END_STONE) || chunk.getBlockState(blockposition4).isCollisionShapeFullBlock(chunk, blockposition4) || chunk.getBlockState(blockposition5).isCollisionShapeFullBlock(chunk, blockposition5)) continue;
            double d1 = blockposition3.distToCenterSqr(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void spawnGatewayPortal(ServerLevel world, BlockPos pos, EndGatewayConfiguration config) {
        Feature.END_GATEWAY.place(config, world, world.getChunkSource().getGenerator(), RandomSource.create(), pos);
    }

    @Override
    public boolean shouldRenderFace(Direction direction) {
        return Block.shouldRenderFace(this.getBlockState(), this.level, this.getBlockPos(), direction, this.getBlockPos().relative(direction));
    }

    public int getParticleAmount() {
        int i = 0;
        for (Direction enumdirection : Direction.values()) {
            i += this.shouldRenderFace(enumdirection) ? 1 : 0;
        }
        return i;
    }

    public void setExitPosition(BlockPos pos, boolean exactTeleport) {
        this.exactTeleport = exactTeleport;
        this.exitPortal = pos;
    }
}

