/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class GlobalPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;

    public GlobalPalette(IdMap<T> idList) {
        this.registry = idList;
    }

    public static <A> Palette<A> create(int bits, IdMap<A> idList, PaletteResize<A> listener, List<A> list) {
        return new GlobalPalette<A>(idList);
    }

    @Override
    @Override
    public int idFor(T object) {
        int i = this.registry.getId(object);
        return i == -1 ? 0 : i;
    }

    @Override
    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        return true;
    }

    @Override
    @Override
    public T valueFor(int id) {
        T object = this.registry.byId(id);
        if (object == null) {
            throw new MissingPaletteEntryException(id);
        }
        return object;
    }

    @Override
    @Override
    public void read(FriendlyByteBuf buf) {
    }

    @Override
    @Override
    public void write(FriendlyByteBuf buf) {
    }

    @Override
    @Override
    public int getSerializedSize() {
        return 0;
    }

    @Override
    @Override
    public int getSize() {
        return this.registry.size();
    }

    @Override
    @Override
    public Palette<T> copy() {
        return this;
    }
}

