/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;

public class SingleValuePalette<T>
implements Palette<T> {
    private final IdMap<T> registry;
    @Nullable
    private T value;
    private final PaletteResize<T> resizeHandler;

    public SingleValuePalette(IdMap<T> idList, PaletteResize<T> listener, List<T> entries) {
        this.registry = idList;
        this.resizeHandler = listener;
        if (entries.size() > 0) {
            Validate.isTrue((entries.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)entries.size());
            this.value = entries.get(0);
        }
    }

    public static <A> Palette<A> create(int bitSize, IdMap<A> idList, PaletteResize<A> listener, List<A> entries) {
        return new SingleValuePalette<A>(idList, listener, entries);
    }

    @Override
    @Override
    public int idFor(T object) {
        if (this.value == null || this.value == object) {
            this.value = object;
            return 0;
        }
        return this.resizeHandler.onResize(1, object);
    }

    @Override
    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return predicate.test(this.value);
    }

    @Override
    @Override
    public T valueFor(int id) {
        if (this.value == null || id != 0) {
            throw new IllegalStateException("Missing Palette entry for id " + id + ".");
        }
        return this.value;
    }

    @Override
    @Override
    public void read(FriendlyByteBuf buf) {
        this.value = this.registry.byIdOrThrow(buf.readVarInt());
    }

    @Override
    @Override
    public void write(FriendlyByteBuf buf) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        buf.writeVarInt(this.registry.getId(this.value));
    }

    @Override
    @Override
    public int getSerializedSize() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(this.registry.getId(this.value));
    }

    @Override
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    @Override
    public Palette<T> copy() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

