/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spigotmc.SpigotConfig;

public class ChunkStorage
implements AutoCloseable {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    private final Object persistentDataLock = new Object();
    public final RegionFileStorage regionFileCache;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile LegacyStructureDataHandler legacyStructureHandler;

    public ChunkStorage(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync) {
        this.fixerUpper = dataFixer;
        this.regionFileCache = new RegionFileStorage(storageKey, directory, dsync, true);
    }

    public boolean isOldChunkAround(ChunkPos chunkPos, int checkRadius) {
        return true;
    }

    private boolean check(ServerChunkCache cps, int x, int z) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag upgradeChunkTag(ResourceKey<LevelStem> resourcekey, Supplier<DimensionDataStorage> supplier, CompoundTag nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkPos pos, @Nullable LevelAccessor generatoraccess) {
        nbttagcompound = nbttagcompound.copy();
        int i = ChunkStorage.getVersion(nbttagcompound);
        try {
            boolean belowZeroGenerationInExistingChunks;
            if (i < 1493) {
                MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, i, 1493);
                if (nbttagcompound.getCompound("Level").getBoolean("hasLegacyStructureData")) {
                    Object object = this.persistentDataLock;
                    synchronized (object) {
                        LegacyStructureDataHandler persistentstructurelegacy = this.getLegacyStructureHandler(resourcekey, supplier);
                        nbttagcompound = persistentstructurelegacy.updateFromLegacy(nbttagcompound);
                    }
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((ServerLevel)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.getCompound("Level").getString("Status"));
            }
            ChunkStorage.injectDatafixingContext(nbttagcompound, resourcekey, optional);
            nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, Math.max(1493, i), SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            if (i < SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
                NbtUtils.addCurrentDataVersion(nbttagcompound);
            }
            if (stopBelowZero) {
                nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            nbttagcompound.remove("__context");
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Updated chunk");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Updated chunk details");
            crashreportsystemdetails.setDetail("Data version", i);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacyStructureDataHandler getLegacyStructureHandler(ResourceKey<LevelStem> worldKey, Supplier<DimensionDataStorage> stateManagerGetter) {
        LegacyStructureDataHandler persistentstructurelegacy = this.legacyStructureHandler;
        if (persistentstructurelegacy == null) {
            Object object = this.persistentDataLock;
            synchronized (object) {
                persistentstructurelegacy = this.legacyStructureHandler;
                if (persistentstructurelegacy == null) {
                    this.legacyStructureHandler = persistentstructurelegacy = LegacyStructureDataHandler.getLegacyStructureHandler(worldKey, stateManagerGetter.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void injectDatafixingContext(CompoundTag nbt, ResourceKey<LevelStem> worldKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> generatorCodecKey) {
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.putString("dimension", worldKey.location().toString());
        generatorCodecKey.ifPresent(resourcekey1 -> nbttagcompound1.putString("generator", resourcekey1.location().toString()));
        nbt.put("__context", nbttagcompound1);
    }

    public static int getVersion(CompoundTag nbt) {
        return NbtUtils.getDataVersion(nbt, -1);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.readSync(chunkPos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    @Nullable
    public CompoundTag readSync(ChunkPos chunkPos) throws IOException {
        return this.regionFileCache.read(chunkPos);
    }

    public CompletableFuture<Void> write(ChunkPos chunkPos, CompoundTag nbt) throws IOException {
        if (nbt != null && !chunkPos.equals(ChunkSerializer.getChunkCoordinate(nbt))) {
            String world = this instanceof ChunkMap ? ((ChunkMap)this).level.getWorld().getName() : null;
            throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(chunkPos) + " but compound says coordinate is " + String.valueOf(ChunkSerializer.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
        }
        this.regionFileCache.write(chunkPos, nbt);
        this.handleLegacyStructureIndex(chunkPos);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLegacyStructureIndex(ChunkPos chunkPos) {
        if (this.legacyStructureHandler != null) {
            Object object = this.persistentDataLock;
            synchronized (object) {
                this.legacyStructureHandler.removeIndex(chunkPos.toLong());
            }
        }
    }

    public void flushWorker() {
        RegionFileIOThread.flush();
    }

    @Override
    public void close() throws IOException {
        this.regionFileCache.close();
    }

    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.regionFileCache.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

