/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ENTITIES_TAG = "Entities";
    private static final String POSITION_TAG = "Position";
    public final ServerLevel level;
    private final LongSet emptyChunks = new LongOpenHashSet();

    public EntityStorage(SimpleRegionStorage storage, ServerLevel world, Executor executor) {
        this.level = world;
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> loadEntities(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    public static List<Entity> readEntities(ServerLevel level, CompoundTag compoundTag) {
        ListTag listTag = compoundTag.getList(ENTITIES_TAG, 10);
        List list = (List)EntityType.loadEntitiesRecursive(listTag, level).collect(ImmutableList.toImmutableList());
        return list;
    }

    public static ChunkPos readChunkPos(CompoundTag chunkNbt) {
        int[] is = chunkNbt.getIntArray(POSITION_TAG);
        return new ChunkPos(is[0], is[1]);
    }

    private static void writeChunkPos(CompoundTag chunkNbt, ChunkPos pos) {
        chunkNbt.put(POSITION_TAG, new IntArrayTag(new int[]{pos.x, pos.z}));
    }

    private static ChunkEntities<Entity> emptyChunk(ChunkPos pos) {
        return new ChunkEntities<Entity>(pos, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void storeEntities(ChunkEntities<Entity> dataList) {
        throw new UnsupportedOperationException();
    }

    public static void copyEntities(CompoundTag from, CompoundTag into) {
        if (from == null) {
            return;
        }
        ListTag entitiesFrom = from.getList(ENTITIES_TAG, 10);
        if (entitiesFrom == null || entitiesFrom.isEmpty()) {
            return;
        }
        ListTag entitiesInto = into.getList(ENTITIES_TAG, 10);
        into.put(ENTITIES_TAG, entitiesInto);
        entitiesInto.addAll(0, entitiesFrom.copy());
    }

    public static CompoundTag saveEntityChunk(List<Entity> entities, ChunkPos chunkPos, ServerLevel level) {
        return EntityStorage.saveEntityChunk0(entities, chunkPos, level, false);
    }

    private static CompoundTag saveEntityChunk0(List<Entity> entities, ChunkPos chunkPos, ServerLevel level, boolean force) {
        if (!force && entities.isEmpty()) {
            return null;
        }
        ListTag listTag = new ListTag();
        HashMap savedEntityCounts = new HashMap();
        entities.forEach(entity -> {
            CompoundTag compoundTag;
            if (!entity.canSaveToDisk()) {
                return;
            }
            EntityType<?> entityType = entity.getType();
            int saveLimit = level.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
            if (saveLimit > -1) {
                if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                    return;
                }
                savedEntityCounts.merge(entityType, 1, Integer::sum);
            }
            if (entity.save(compoundTag = new CompoundTag())) {
                listTag.add(compoundTag);
            }
        });
        CompoundTag compoundTag = NbtUtils.addCurrentDataVersion(new CompoundTag());
        compoundTag.put(ENTITIES_TAG, listTag);
        EntityStorage.writeChunkPos(compoundTag, chunkPos);
        return !force && listTag.isEmpty() ? null : compoundTag;
    }

    public static CompoundTag upgradeChunkTag(CompoundTag chunkNbt) {
        int i = NbtUtils.getDataVersion(chunkNbt, -1);
        return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, chunkNbt, i, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
    }

    @Override
    public void flush(boolean sync) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }
}

