/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public class SimpleRegionStorage
implements AutoCloseable {
    private final IOWorker worker;
    private final DataFixer fixerUpper;
    private final DataFixTypes dataFixType;

    public SimpleRegionStorage(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync, DataFixTypes dataFixTypes) {
        this.fixerUpper = dataFixer;
        this.dataFixType = dataFixTypes;
        this.worker = new IOWorker(storageKey, directory, dsync);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        return this.worker.loadAsync(pos);
    }

    public CompletableFuture<Void> write(ChunkPos pos, @Nullable CompoundTag nbt) {
        return this.worker.store(pos, nbt);
    }

    private MCDataType getDataConverterType() {
        if (this.dataFixType == DataFixTypes.ENTITY_CHUNK) {
            return MCTypeRegistry.ENTITY_CHUNK;
        }
        if (this.dataFixType == DataFixTypes.POI_CHUNK) {
            return MCTypeRegistry.POI_CHUNK;
        }
        throw new UnsupportedOperationException("For " + this.dataFixType.name());
    }

    public CompoundTag upgradeChunkTag(CompoundTag nbt, int oldVersion) {
        int dataVer = NbtUtils.getDataVersion(nbt, oldVersion);
        return MCDataConverter.convertTag(this.getDataConverterType(), nbt, dataVer, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
    }

    public Dynamic<Tag> upgradeChunkTag(Dynamic<Tag> nbt, int oldVersion) {
        CompoundTag converted = MCDataConverter.convertTag(this.getDataConverterType(), (CompoundTag)nbt.getValue(), oldVersion, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return new Dynamic<Tag>(NbtOps.INSTANCE, converted);
    }

    public CompletableFuture<Void> synchronize(boolean sync) {
        return this.worker.synchronize(sync);
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }
}

