/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<LeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(LeaveVineDecorator::new, treeDecorator -> Float.valueOf(treeDecorator.probability));
    private final float probability;

    @Override
    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.LEAVE_VINE;
    }

    public LeaveVineDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    @Override
    public void place(TreeDecorator.Context generator) {
        RandomSource randomSource = generator.random();
        generator.leaves().forEach(pos -> {
            BlockPos blockPos4;
            BlockPos blockPos3;
            BlockPos blockPos2;
            BlockPos blockPos;
            if (randomSource.nextFloat() < this.probability && generator.isAir(blockPos = pos.west())) {
                LeaveVineDecorator.addHangingVine(blockPos, VineBlock.EAST, generator);
            }
            if (randomSource.nextFloat() < this.probability && generator.isAir(blockPos2 = pos.east())) {
                LeaveVineDecorator.addHangingVine(blockPos2, VineBlock.WEST, generator);
            }
            if (randomSource.nextFloat() < this.probability && generator.isAir(blockPos3 = pos.north())) {
                LeaveVineDecorator.addHangingVine(blockPos3, VineBlock.SOUTH, generator);
            }
            if (randomSource.nextFloat() < this.probability && generator.isAir(blockPos4 = pos.south())) {
                LeaveVineDecorator.addHangingVine(blockPos4, VineBlock.NORTH, generator);
            }
        });
    }

    private static void addHangingVine(BlockPos pos, BooleanProperty faceProperty, TreeDecorator.Context generator) {
        generator.placeVine(pos, faceProperty);
        pos = pos.below();
        for (int i = 4; generator.isAir(pos) && i > 0; --i) {
            generator.placeVine(pos, faceProperty);
            pos = pos.below();
        }
    }
}

