/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureTemplateManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String STRUCTURE_DIRECTORY_NAME = "structures";
    private static final String STRUCTURE_FILE_EXTENSION = ".nbt";
    private static final String STRUCTURE_TEXT_FILE_EXTENSION = ".snbt";
    public final Map<ResourceLocation, Optional<StructureTemplate>> structureRepository = Maps.newConcurrentMap();
    private final DataFixer fixerUpper;
    private ResourceManager resourceManager;
    private final Path generatedDir;
    private final List<Source> sources;
    private final HolderGetter<Block> blockLookup;
    private static final FileToIdConverter LISTER = new FileToIdConverter("structures", ".nbt");

    public StructureTemplateManager(ResourceManager resourceManager, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, HolderGetter<Block> blockLookup) {
        this.resourceManager = resourceManager;
        this.fixerUpper = dataFixer;
        this.generatedDir = session.getLevelPath(LevelResource.GENERATED_DIR).normalize();
        this.blockLookup = blockLookup;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Source(this::loadFromGenerated, this::listGenerated));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            builder.add((Object)new Source(this::loadFromTestStructures, this::listTestStructures));
        }
        builder.add((Object)new Source(this::loadFromResource, this::listResources));
        this.sources = builder.build();
    }

    public StructureTemplate getOrCreate(ResourceLocation id) {
        Optional<StructureTemplate> optional = this.get(id);
        if (optional.isPresent()) {
            return optional.get();
        }
        StructureTemplate structureTemplate = new StructureTemplate();
        this.structureRepository.put(id, Optional.of(structureTemplate));
        return structureTemplate;
    }

    public Optional<StructureTemplate> get(ResourceLocation id) {
        return this.structureRepository.computeIfAbsent(id, this::tryLoad);
    }

    public Stream<ResourceLocation> listTemplates() {
        return this.sources.stream().flatMap(provider -> provider.lister().get()).distinct();
    }

    private Optional<StructureTemplate> tryLoad(ResourceLocation id) {
        for (Source source : this.sources) {
            try {
                Optional<StructureTemplate> optional = source.loader().apply(id);
                if (!optional.isPresent()) continue;
                return optional;
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.structureRepository.clear();
    }

    public Optional<StructureTemplate> loadFromResource(ResourceLocation id) {
        ResourceLocation resourceLocation = LISTER.idToFile(id);
        return this.load(() -> this.resourceManager.open(resourceLocation), throwable -> LOGGER.error("Couldn't load structure {}", (Object)id, throwable));
    }

    private Stream<ResourceLocation> listResources() {
        return LISTER.listMatchingResources(this.resourceManager).keySet().stream().map(LISTER::fileToId);
    }

    private Optional<StructureTemplate> loadFromTestStructures(ResourceLocation id) {
        return this.loadFromSnbt(id, Paths.get(StructureUtils.testStructuresDir, new String[0]));
    }

    private Stream<ResourceLocation> listTestStructures() {
        return this.listFolderContents(Paths.get(StructureUtils.testStructuresDir, new String[0]), "minecraft", STRUCTURE_TEXT_FILE_EXTENSION);
    }

    public Optional<StructureTemplate> loadFromGenerated(ResourceLocation id) {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path = StructureTemplateManager.createAndValidatePathToStructure(this.generatedDir, id, STRUCTURE_FILE_EXTENSION);
        return this.load(() -> new FileInputStream(path.toFile()), throwable -> LOGGER.error("Couldn't load structure from {}", (Object)path, throwable));
    }

    private Stream<ResourceLocation> listGenerated() {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(this.generatedDir).filter(path -> Files.isDirectory(path, new LinkOption[0])).flatMap(path -> this.listGeneratedInNamespace((Path)path));
        }
        catch (IOException var2) {
            return Stream.empty();
        }
    }

    private Stream<ResourceLocation> listGeneratedInNamespace(Path namespaceDirectory) {
        Path path = namespaceDirectory.resolve(STRUCTURE_DIRECTORY_NAME);
        return this.listFolderContents(path, namespaceDirectory.getFileName().toString(), STRUCTURE_FILE_EXTENSION);
    }

    private Stream<ResourceLocation> listFolderContents(Path structuresDirectoryPath, String namespace, String extension) {
        if (!Files.isDirectory(structuresDirectoryPath, new LinkOption[0])) {
            return Stream.empty();
        }
        int i = extension.length();
        Function<String, String> function = filename -> filename.substring(0, filename.length() - i);
        try {
            return Files.walk(structuresDirectoryPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(extension)).mapMulti((path, consumer) -> {
                try {
                    consumer.accept(new ResourceLocation(namespace, (String)function.apply(this.relativize(structuresDirectoryPath, (Path)path))));
                }
                catch (ResourceLocationException var7x) {
                    LOGGER.error("Invalid location while listing pack contents", (Throwable)var7x);
                }
            });
        }
        catch (IOException var7) {
            LOGGER.error("Failed to list folder contents", (Throwable)var7);
            return Stream.empty();
        }
    }

    private String relativize(Path root, Path path) {
        return root.relativize(path).toString().replace(File.separator, "/");
    }

    private Optional<StructureTemplate> loadFromSnbt(ResourceLocation id, Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path2 = FileUtil.createPathToResource(path, id.getPath(), STRUCTURE_TEXT_FILE_EXTENSION);
        try {
            Optional<StructureTemplate> var6;
            try (BufferedReader bufferedReader = Files.newBufferedReader(path2);){
                String string = IOUtils.toString((Reader)bufferedReader);
                var6 = Optional.of(this.readStructure(NbtUtils.snbtToStructure(string)));
            }
            return var6;
        }
        catch (NoSuchFileException var9) {
            return Optional.empty();
        }
        catch (CommandSyntaxException | IOException var10) {
            LOGGER.error("Couldn't load structure from {}", (Object)path2, (Object)var10);
            return Optional.empty();
        }
    }

    private Optional<StructureTemplate> load(InputStreamOpener opener, Consumer<Throwable> exceptionConsumer) {
        try {
            Optional<StructureTemplate> var5;
            try (InputStream inputStream = opener.open();
                 FastBufferedInputStream inputStream2 = new FastBufferedInputStream(inputStream);){
                var5 = Optional.of(this.readStructure(inputStream2));
            }
            return var5;
        }
        catch (FileNotFoundException var11) {
            return Optional.empty();
        }
        catch (Throwable var12) {
            exceptionConsumer.accept(var12);
            return Optional.empty();
        }
    }

    public StructureTemplate readStructure(InputStream templateIInputStream) throws IOException {
        CompoundTag compoundTag = NbtIo.readCompressed(templateIInputStream, NbtAccounter.unlimitedHeap());
        return this.readStructure(compoundTag);
    }

    public StructureTemplate readStructure(CompoundTag nbt) {
        StructureTemplate structureTemplate = new StructureTemplate();
        int i = NbtUtils.getDataVersion(nbt, 500);
        structureTemplate.load(this.blockLookup, MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, i, SharedConstants.getCurrentVersion().getDataVersion().getVersion()));
        return structureTemplate;
    }

    public boolean save(ResourceLocation id) {
        Optional<StructureTemplate> optional = this.structureRepository.get(id);
        if (optional.isEmpty()) {
            return false;
        }
        StructureTemplate structureTemplate = optional.get();
        Path path = StructureTemplateManager.createAndValidatePathToStructure(this.generatedDir, id, STRUCTURE_FILE_EXTENSION);
        Path path2 = path.getParent();
        if (path2 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path2, new LinkOption[0]) ? path2.toRealPath(new LinkOption[0]) : path2, new FileAttribute[0]);
        }
        catch (IOException var13) {
            LOGGER.error("Failed to create parent directory: {}", (Object)path2);
            return false;
        }
        CompoundTag compoundTag = structureTemplate.save(new CompoundTag());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
                NbtIo.writeCompressed(compoundTag, outputStream);
            }
            return true;
        }
        catch (Throwable var12) {
            return false;
        }
    }

    public Path getPathToGeneratedStructure(ResourceLocation id, String extension) {
        return StructureTemplateManager.createPathToStructure(this.generatedDir, id, extension);
    }

    public static Path createPathToStructure(Path path, ResourceLocation id, String extension) {
        try {
            Path path2 = path.resolve(id.getNamespace());
            Path path3 = path2.resolve(STRUCTURE_DIRECTORY_NAME);
            return FileUtil.createPathToResource(path3, id.getPath(), extension);
        }
        catch (InvalidPathException var5) {
            throw new ResourceLocationException("Invalid resource path: " + String.valueOf(id), var5);
        }
    }

    public static Path createAndValidatePathToStructure(Path path, ResourceLocation id, String extension) {
        if (id.getPath().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + String.valueOf(id));
        }
        Path path2 = StructureTemplateManager.createPathToStructure(path, id, extension);
        if (path2.startsWith(path) && FileUtil.isPathNormalized(path2) && FileUtil.isPathPortable(path2)) {
            return path2;
        }
        throw new ResourceLocationException("Invalid resource path: " + String.valueOf(path2));
    }

    public void remove(ResourceLocation id) {
        this.structureRepository.remove(id);
    }

    record Source(Function<ResourceLocation, Optional<StructureTemplate>> loader, Supplier<Stream<ResourceLocation>> lister) {
    }

    @FunctionalInterface
    static interface InputStreamOpener {
        public InputStream open() throws IOException;
    }
}

