/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;

public final class BlockLightEngine
extends LightEngine<BlockLightSectionStorage.BlockDataLayerStorageMap, BlockLightSectionStorage> {
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public BlockLightEngine(LightChunkGetter chunkProvider) {
        this(chunkProvider, new BlockLightSectionStorage(chunkProvider));
    }

    @VisibleForTesting
    public BlockLightEngine(LightChunkGetter chunkProvider, BlockLightSectionStorage blockLightStorage) {
        super(chunkProvider, blockLightStorage);
    }

    @Override
    @Override
    protected void checkNode(long blockPos) {
        int j;
        long l = SectionPos.blockToSection(blockPos);
        if (!((BlockLightSectionStorage)this.storage).storingLightForSection(l)) {
            return;
        }
        BlockState blockState = this.getState(this.mutablePos.set(blockPos));
        int i = this.getEmission(blockPos, blockState);
        if (i < (j = ((BlockLightSectionStorage)this.storage).getStoredLevel(blockPos))) {
            ((BlockLightSectionStorage)this.storage).setStoredLevel(blockPos, 0);
            this.enqueueDecrease(blockPos, LightEngine.QueueEntry.decreaseAllDirections(j));
        } else {
            this.enqueueDecrease(blockPos, LightEngine.PULL_LIGHT_IN_ENTRY);
        }
        if (i > 0) {
            this.enqueueIncrease(blockPos, LightEngine.QueueEntry.increaseLightFromEmission(i, BlockLightEngine.isEmptyShape(blockState)));
        }
    }

    @Override
    @Override
    protected void propagateIncrease(long blockPos, long l, int lightLevel) {
        BlockState blockState = null;
        for (Direction direction : LightEngine.PROPAGATION_DIRECTIONS) {
            int i;
            int j;
            long m;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(l, direction) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(m = BlockPos.offset(blockPos, direction))) || (j = lightLevel - 1) <= (i = ((BlockLightSectionStorage)this.storage).getStoredLevel(m))) continue;
            this.mutablePos.set(m);
            BlockState blockState2 = this.getState(this.mutablePos);
            int k = lightLevel - this.getOpacity(blockState2, this.mutablePos);
            if (k <= i) continue;
            if (blockState == null) {
                BlockState blockState3 = blockState = LightEngine.QueueEntry.isFromEmptyShape(l) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(blockPos));
            }
            if (this.shapeOccludes(blockPos, blockState, m, blockState2, direction)) continue;
            ((BlockLightSectionStorage)this.storage).setStoredLevel(m, k);
            if (k <= 1) continue;
            this.enqueueIncrease(m, LightEngine.QueueEntry.increaseSkipOneDirection(k, BlockLightEngine.isEmptyShape(blockState2), direction.getOpposite()));
        }
    }

    @Override
    @Override
    protected void propagateDecrease(long blockPos, long l) {
        int i = LightEngine.QueueEntry.getFromLevel(l);
        for (Direction direction : LightEngine.PROPAGATION_DIRECTIONS) {
            int j;
            long m;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(l, direction) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(m = BlockPos.offset(blockPos, direction))) || (j = ((BlockLightSectionStorage)this.storage).getStoredLevel(m)) == 0) continue;
            if (j <= i - 1) {
                BlockState blockState = this.getState(this.mutablePos.set(m));
                int k = this.getEmission(m, blockState);
                ((BlockLightSectionStorage)this.storage).setStoredLevel(m, 0);
                if (k < j) {
                    this.enqueueDecrease(m, LightEngine.QueueEntry.decreaseSkipOneDirection(j, direction.getOpposite()));
                }
                if (k <= 0) continue;
                this.enqueueIncrease(m, LightEngine.QueueEntry.increaseLightFromEmission(k, BlockLightEngine.isEmptyShape(blockState)));
                continue;
            }
            this.enqueueIncrease(m, LightEngine.QueueEntry.increaseOnlyOneDirection(j, false, direction.getOpposite()));
        }
    }

    private int getEmission(long blockPos, BlockState blockState) {
        int i = blockState.getLightEmission();
        if (i > 0 && ((BlockLightSectionStorage)this.storage).lightOnInSection(SectionPos.blockToSection(blockPos))) {
            return i;
        }
        return 0;
    }

    @Override
    @Override
    public void propagateLightSources(ChunkPos chunkPos) {
        this.setLightEnabled(chunkPos, true);
        LightChunk lightChunk = this.chunkSource.getChunkForLighting(chunkPos.x, chunkPos.z);
        if (lightChunk != null) {
            lightChunk.findBlockLightSources((blockPos, blockState) -> {
                int i = blockState.getLightEmission();
                this.enqueueIncrease(blockPos.asLong(), LightEngine.QueueEntry.increaseLightFromEmission(i, BlockLightEngine.isEmptyShape(blockState)));
            });
        }
    }
}

