/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import java.util.UUID;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.TimerQueue;

public class DerivedLevelData
implements ServerLevelData {
    private final WorldData worldData;
    private final ServerLevelData wrapped;

    public DerivedLevelData(WorldData saveProperties, ServerLevelData worldProperties) {
        this.worldData = saveProperties;
        this.wrapped = worldProperties;
    }

    @Override
    @Override
    public BlockPos getSpawnPos() {
        return this.wrapped.getSpawnPos();
    }

    @Override
    @Override
    public float getSpawnAngle() {
        return this.wrapped.getSpawnAngle();
    }

    @Override
    @Override
    public long getGameTime() {
        return this.wrapped.getGameTime();
    }

    @Override
    @Override
    public long getDayTime() {
        return this.wrapped.getDayTime();
    }

    @Override
    @Override
    public String getLevelName() {
        return this.worldData.getLevelName();
    }

    @Override
    @Override
    public int getClearWeatherTime() {
        return this.wrapped.getClearWeatherTime();
    }

    @Override
    @Override
    public void setClearWeatherTime(int clearWeatherTime) {
    }

    @Override
    @Override
    public boolean isThundering() {
        return this.wrapped.isThundering();
    }

    @Override
    @Override
    public int getThunderTime() {
        return this.wrapped.getThunderTime();
    }

    @Override
    @Override
    public boolean isRaining() {
        return this.wrapped.isRaining();
    }

    @Override
    @Override
    public int getRainTime() {
        return this.wrapped.getRainTime();
    }

    @Override
    @Override
    public GameType getGameType() {
        return this.worldData.getGameType();
    }

    @Override
    @Override
    public void setGameTime(long time) {
    }

    @Override
    @Override
    public void setDayTime(long timeOfDay) {
    }

    @Override
    @Override
    public void setSpawn(BlockPos pos, float angle) {
    }

    @Override
    @Override
    public void setThundering(boolean thundering) {
    }

    @Override
    @Override
    public void setThunderTime(int thunderTime) {
    }

    @Override
    @Override
    public void setRaining(boolean raining) {
    }

    @Override
    @Override
    public void setRainTime(int rainTime) {
    }

    @Override
    @Override
    public void setGameType(GameType gameMode) {
    }

    @Override
    @Override
    public boolean isHardcore() {
        return this.worldData.isHardcore();
    }

    @Override
    @Override
    public boolean isAllowCommands() {
        return this.worldData.isAllowCommands();
    }

    @Override
    @Override
    public boolean isInitialized() {
        return this.wrapped.isInitialized();
    }

    @Override
    @Override
    public void setInitialized(boolean initialized) {
    }

    @Override
    @Override
    public GameRules getGameRules() {
        return this.worldData.getGameRules();
    }

    @Override
    @Override
    public WorldBorder.Settings getWorldBorder() {
        return this.wrapped.getWorldBorder();
    }

    @Override
    @Override
    public void setWorldBorder(WorldBorder.Settings worldBorder) {
    }

    @Override
    @Override
    public Difficulty getDifficulty() {
        return this.worldData.getDifficulty();
    }

    @Override
    @Override
    public boolean isDifficultyLocked() {
        return this.worldData.isDifficultyLocked();
    }

    @Override
    @Override
    public TimerQueue<MinecraftServer> getScheduledEvents() {
        return this.wrapped.getScheduledEvents();
    }

    @Override
    @Override
    public int getWanderingTraderSpawnDelay() {
        return 0;
    }

    @Override
    @Override
    public void setWanderingTraderSpawnDelay(int wanderingTraderSpawnDelay) {
    }

    @Override
    @Override
    public int getWanderingTraderSpawnChance() {
        return 0;
    }

    @Override
    @Override
    public void setWanderingTraderSpawnChance(int wanderingTraderSpawnChance) {
    }

    @Override
    @Override
    public UUID getWanderingTraderId() {
        return null;
    }

    @Override
    @Override
    public void setWanderingTraderId(UUID wanderingTraderId) {
    }

    @Override
    @Override
    public void fillCrashReportCategory(CrashReportCategory reportSection, LevelHeightAccessor world) {
        reportSection.setDetail("Derived", true);
        this.wrapped.fillCrashReportCategory(reportSection, world);
    }
}

