/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public interface ContainerComponentManipulator<T> {
    public DataComponentType<T> type();

    public T empty();

    public T setContents(T var1, Stream<ItemStack> var2);

    public Stream<ItemStack> getContents(T var1);

    default public void setContents(ItemStack stack, T component, Stream<ItemStack> contents) {
        T object = stack.getOrDefault(this.type(), component);
        T object2 = this.setContents(object, contents);
        stack.set(this.type(), object2);
    }

    default public void setContents(ItemStack stack, Stream<ItemStack> contents) {
        this.setContents(stack, this.empty(), contents);
    }

    default public void modifyItems(ItemStack stack, UnaryOperator<ItemStack> contentsOperator) {
        T object = stack.get(this.type());
        if (object != null) {
            UnaryOperator unaryOperator = contentStack -> contentStack.isEmpty() ? contentStack : (ItemStack)contentsOperator.apply((ItemStack)contentStack);
            this.setContents(stack, this.getContents(object).map(unaryOperator));
        }
    }
}

