/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetLoreFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetLoreFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetLoreFunction.commonFields(instance).and(instance.group((App)ComponentSerialization.CODEC.sizeLimitedListOf(256).fieldOf("lore").forGetter(function -> function.lore), (App)ListOperation.codec(256).forGetter(function -> function.mode), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(function -> function.resolutionContext))).apply((Applicative)instance, SetLoreFunction::new));
    private final List<Component> lore;
    private final ListOperation mode;
    private final Optional<LootContext.EntityTarget> resolutionContext;

    public SetLoreFunction(List<LootItemCondition> conditions, List<Component> lore, ListOperation operation, Optional<LootContext.EntityTarget> entity) {
        super(conditions);
        this.lore = List.copyOf(lore);
        this.mode = operation;
        this.resolutionContext = entity;
    }

    @Override
    public LootItemFunctionType<SetLoreFunction> getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.resolutionContext.map(entity -> Set.of(entity.getParam())).orElseGet(Set::of);
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        stack.update(DataComponents.LORE, ItemLore.EMPTY, component -> new ItemLore(this.updateLore((ItemLore)component, context)));
        return stack;
    }

    private List<Component> updateLore(@Nullable ItemLore current, LootContext context) {
        if (current == null && this.lore.isEmpty()) {
            return List.of();
        }
        UnaryOperator<Component> unaryOperator = SetNameFunction.createResolver(context, this.resolutionContext.orElse(null));
        List list = this.lore.stream().map(unaryOperator).toList();
        List<Component> list2 = this.mode.apply(current.lines(), list, 256);
        return list2;
    }

    public static Builder setLore() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private Optional<LootContext.EntityTarget> resolutionContext = Optional.empty();
        private final ImmutableList.Builder<Component> lore = ImmutableList.builder();
        private ListOperation mode = ListOperation.Append.INSTANCE;

        public Builder setMode(ListOperation operation) {
            this.mode = operation;
            return this;
        }

        public Builder setResolutionContext(LootContext.EntityTarget target) {
            this.resolutionContext = Optional.of(target);
            return this;
        }

        public Builder addLine(Component lore) {
            this.lore.add((Object)lore);
            return this;
        }

        @Override
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction build() {
            return new SetLoreFunction(this.getConditions(), (List<Component>)this.lore.build(), this.mode, this.resolutionContext);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

