/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.DoubleMath;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.collisions.CachedShapeData;
import io.papermc.paper.util.collisions.CachedToAABBs;
import io.papermc.paper.util.collisions.FlatBitsetUtil;
import io.papermc.paper.util.collisions.MergedORCache;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;

public abstract class VoxelShape {
    public final DiscreteVoxelShape shape;
    @Nullable
    private VoxelShape[] faces;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    @Nullable
    private AABB singleAABBRepresentation;
    private double[] rootCoordinatesX;
    private double[] rootCoordinatesY;
    private double[] rootCoordinatesZ;
    private CachedShapeData cachedShapeData;
    private boolean isEmpty;
    private CachedToAABBs cachedToAABBs;
    private AABB cachedBounds;
    private Boolean isFullBlock;
    private Boolean occludesFullBlock;
    private static final int MERGED_CACHE_SIZE = 16;
    private MergedORCache[] mergedORCache;
    private VoxelShape[] faceShapeClampedCache;

    public final double offsetX() {
        return this.offsetX;
    }

    public final double offsetY() {
        return this.offsetY;
    }

    public final double offsetZ() {
        return this.offsetZ;
    }

    public final AABB getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    public final double[] rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    public final double[] rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    public final double[] rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    public final void initCache() {
        OffsetDoubleList offsetDoubleList;
        this.cachedShapeData = this.shape.getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.getCoords(Direction.Axis.X);
        DoubleList yList = this.getCoords(Direction.Axis.Y);
        DoubleList zList = this.getCoords(Direction.Axis.Z);
        if (xList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)xList;
            this.offsetX = offsetDoubleList.offset;
            this.rootCoordinatesX = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesX = VoxelShape.extractRawArray(xList);
        }
        if (yList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)yList;
            this.offsetY = offsetDoubleList.offset;
            this.rootCoordinatesY = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesY = VoxelShape.extractRawArray(yList);
        }
        if (zList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)zList;
            this.offsetZ = offsetDoubleList.offset;
            this.rootCoordinatesZ = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesZ = VoxelShape.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new AABB(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    public final CachedShapeData getCachedVoxelData() {
        return this.cachedShapeData;
    }

    public final VoxelShape getFaceShapeClamped(Direction direction) {
        VoxelShape ret;
        if (this.isEmpty) {
            return this;
        }
        if (this == Shapes.block()) {
            return this;
        }
        VoxelShape[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new VoxelShape[6];
        }
        Direction.Axis axis = direction.getAxis();
        VoxelShape ret2 = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (DoubleMath.fuzzyEquals((double)this.max(axis), (double)1.0, (double)1.0E-7) ? VoxelShape.tryForceBlock(new SliceShape(this, axis, this.shape.getSize(axis) - 1)) : Shapes.empty()) : (DoubleMath.fuzzyEquals((double)this.min(axis), (double)0.0, (double)1.0E-7) ? VoxelShape.tryForceBlock(new SliceShape(this, axis, 0)) : Shapes.empty());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    private static VoxelShape tryForceBlock(VoxelShape other) {
        if (other == Shapes.block()) {
            return other;
        }
        AABB otherAABB = other.getSingleAABBRepresentation();
        if (otherAABB == null) {
            return other;
        }
        if (Shapes.block().getSingleAABBRepresentation().equals(otherAABB)) {
            return Shapes.block();
        }
        return other;
    }

    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.minY <= 1.0E-7 && singleAABB.maxY >= 0.9999999 && singleAABB.minX <= 1.0E-7 && singleAABB.maxX >= 0.9999999 && singleAABB.minZ <= 1.0E-7 && singleAABB.maxZ >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !Shapes.joinIsNotEmpty(Shapes.block(), this, BooleanOp.ONLY_FIRST);
        this.occludesFullBlock = ret;
        return ret;
    }

    public final boolean occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    public final boolean occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    private static int hash(VoxelShape key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    public final VoxelShape orUnoptimized(VoxelShape other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if (this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        int thisCacheKey = VoxelShape.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShape.hash(this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = other.mergedORCache == null ? null : other.mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == this) {
            return otherCache.result();
        }
        VoxelShape result = Shapes.joinUnoptimized(this, other, BooleanOp.OR);
        if (cached != null && otherCache == null) {
            if (other.mergedORCache == null) {
                other.mergedORCache = new MergedORCache[16];
            }
            other.mergedORCache[otherCacheKey] = new MergedORCache(this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if (this == Shapes.block()) {
                ret = Boolean.TRUE;
            } else {
                AABB singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x = sMinX; x < sMaxX; ++x) {
                            for (int y = sMinY; y < sMaxY; ++y) {
                                int baseIndex = y * sizeZ + x * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.minX) <= 1.0E-7 && Math.abs(singleAABB.minY) <= 1.0E-7 && Math.abs(singleAABB.minZ) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxX) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxY) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxZ) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    public boolean isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    protected VoxelShape(DiscreteVoxelShape voxels) {
        this.shape = voxels;
    }

    public double min(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double max(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public AABB bounds() {
        if (this.isEmpty) {
            throw Util.pauseInIde(new UnsupportedOperationException("No bounds for empty shape."));
        }
        AABB cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new AABB(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    public VoxelShape singleEncompassing() {
        return this.isEmpty() ? Shapes.empty() : Shapes.box(this.min(Direction.Axis.X), this.min(Direction.Axis.Y), this.min(Direction.Axis.Z), this.max(Direction.Axis.X), this.max(Direction.Axis.Y), this.max(Direction.Axis.Z));
    }

    protected double get(Direction.Axis axis, int index) {
        return this.getCoords(axis).getDouble(index);
    }

    protected abstract DoubleList getCoords(Direction.Axis var1);

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private static DoubleList offsetList(DoubleList src, double by) {
        if (src instanceof OffsetDoubleList) {
            OffsetDoubleList offsetDoubleList = (OffsetDoubleList)src;
            return new OffsetDoubleList(offsetDoubleList.delegate, by + offsetDoubleList.offset);
        }
        return new OffsetDoubleList(src, by);
    }

    public VoxelShape move(double x, double y, double z) {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        ArrayVoxelShape ret = new ArrayVoxelShape(this.shape, VoxelShape.offsetList(this.getCoords(Direction.Axis.X), x), VoxelShape.offsetList(this.getCoords(Direction.Axis.Y), y), VoxelShape.offsetList(this.getCoords(Direction.Axis.Z), z));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ret.cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, x, y, z);
        }
        return ret;
    }

    public VoxelShape optimize() {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        if (this.singleAABBRepresentation != null) {
            return this.isFullBlock() ? Shapes.block() : this;
        }
        List<AABB> aabbs = this.toAabbs();
        if (aabbs.size() == 1) {
            AABB singleAABB = aabbs.get(0);
            VoxelShape ret = Shapes.create(singleAABB);
            if (ret.cachedToAABBs == null) {
                ret.cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        VoxelShape[] tmp = new VoxelShape[aabbs.size()];
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            tmp[i] = Shapes.create(aabbs.get(i));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized(first, second, BooleanOp.OR);
            }
            size = newSize;
        }
        VoxelShape ret = tmp[0];
        if (ret.cachedToAABBs == null) {
            ret.cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    public void forAllEdges(Shapes.DoubleLineConsumer consumer) {
        this.shape.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> consumer.consume(this.get(Direction.Axis.X, minX), this.get(Direction.Axis.Y, minY), this.get(Direction.Axis.Z, minZ), this.get(Direction.Axis.X, maxX), this.get(Direction.Axis.Y, maxY), this.get(Direction.Axis.Z, maxZ)), true);
    }

    public void forAllBoxes(Shapes.DoubleLineConsumer consumer) {
        DoubleList doubleList = this.getCoords(Direction.Axis.X);
        DoubleList doubleList2 = this.getCoords(Direction.Axis.Y);
        DoubleList doubleList3 = this.getCoords(Direction.Axis.Z);
        this.shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> consumer.consume(doubleList.getDouble(minX), doubleList2.getDouble(minY), doubleList3.getDouble(minZ), doubleList.getDouble(maxX), doubleList2.getDouble(maxY), doubleList3.getDouble(maxZ)), true);
    }

    private List<AABB> toAabbsUncached() {
        ArrayList<AABB> ret = new ArrayList<AABB>();
        if (this.singleAABBRepresentation != null) {
            ret.add(this.singleAABBRepresentation);
        } else {
            this.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> ret.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ)));
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    public List<AABB> toAabbs() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    public double min(Direction.Axis axis, double from, double to) {
        int j;
        Direction.Axis axis2 = AxisCycle.FORWARD.cycle(axis);
        Direction.Axis axis3 = AxisCycle.BACKWARD.cycle(axis);
        int i = this.findIndex(axis2, from);
        int k = this.shape.firstFull(axis, i, j = this.findIndex(axis3, to));
        return k >= this.shape.getSize(axis) ? Double.POSITIVE_INFINITY : this.get(axis, k);
    }

    public double max(Direction.Axis axis, double from, double to) {
        int j;
        Direction.Axis axis2 = AxisCycle.FORWARD.cycle(axis);
        Direction.Axis axis3 = AxisCycle.BACKWARD.cycle(axis);
        int i = this.findIndex(axis2, from);
        int k = this.shape.lastFull(axis, i, j = this.findIndex(axis3, to));
        return k <= 0 ? Double.NEGATIVE_INFINITY : this.get(axis, k);
    }

    protected int findIndex(Direction.Axis axis, double coord) {
        return Mth.binarySearch(0, this.shape.getSize(axis) + 1, i -> coord < this.get(axis, i)) - 1;
    }

    private static BlockHitResult clip(AABB aabb, Vec3 from, Vec3 to, BlockPos offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.x - from.x;
        double diffY = to.y - from.y;
        double diffZ = to.z - from.z;
        Direction direction = AABB.getDirection(aabb.move(offset), from, minDistanceArr, null, diffX, diffY, diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new BlockHitResult(from.add(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    @Nullable
    public BlockHitResult clip(Vec3 start, Vec3 end, BlockPos pos) {
        if (this.isEmpty) {
            return null;
        }
        Vec3 directionOpposite = end.subtract(start);
        if (directionOpposite.lengthSqr() < 1.0E-7) {
            return null;
        }
        Vec3 fromBehind = start.add(directionOpposite.scale(0.001));
        double fromBehindOffsetX = fromBehind.x - (double)pos.getX();
        double fromBehindOffsetY = fromBehind.y - (double)pos.getY();
        double fromBehindOffsetZ = fromBehind.z - (double)pos.getZ();
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.contains(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new BlockHitResult(fromBehind, Direction.getNearest(directionOpposite.x, directionOpposite.y, directionOpposite.z).getOpposite(), pos, true);
            }
            return VoxelShape.clip(singleAABB, start, end, pos);
        }
        if (CollisionUtil.strictlyContains(this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new BlockHitResult(fromBehind, Direction.getNearest(directionOpposite.x, directionOpposite.y, directionOpposite.z).getOpposite(), pos, true);
        }
        return AABB.clip(this.toAabbs(), start, end, pos);
    }

    public Optional<Vec3> closestPointTo(Vec3 target) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        Vec3 ret = null;
        double retDistance = Double.MAX_VALUE;
        List<AABB> aabbs = this.toAabbs();
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            double z;
            double y;
            AABB aabb = aabbs.get(i);
            double x = Mth.clamp(target.x, aabb.minX, aabb.maxX);
            double dist = target.distanceToSqr(x, y = Mth.clamp(target.y, aabb.minY, aabb.maxY), z = Mth.clamp(target.z, aabb.minZ, aabb.maxZ));
            if (!(dist < retDistance)) continue;
            ret = new Vec3(x, y, z);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }

    public VoxelShape getFaceShape(Direction facing) {
        if (!this.isEmpty() && this != Shapes.block()) {
            VoxelShape voxelShape2;
            if (this.faces != null) {
                VoxelShape voxelShape = this.faces[facing.ordinal()];
                if (voxelShape != null) {
                    return voxelShape;
                }
            } else {
                this.faces = new VoxelShape[6];
            }
            this.faces[facing.ordinal()] = voxelShape2 = this.calculateFace(facing);
            return voxelShape2;
        }
        return this;
    }

    private VoxelShape calculateFace(Direction direction) {
        Direction.Axis axis = direction.getAxis();
        DoubleList doubleList = this.getCoords(axis);
        if (doubleList.size() == 2 && DoubleMath.fuzzyEquals((double)doubleList.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)doubleList.getDouble(1), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        Direction.AxisDirection axisDirection = direction.getAxisDirection();
        int i = this.findIndex(axis, axisDirection == Direction.AxisDirection.POSITIVE ? 0.9999999 : 1.0E-7);
        return new SliceShape(this, axis, i);
    }

    public double collide(Direction.Axis axis, AABB box, double maxDist) {
        if (this.isEmpty) {
            return maxDist;
        }
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case X: {
                return CollisionUtil.collideX(this, box, maxDist);
            }
            case Y: {
                return CollisionUtil.collideY(this, box, maxDist);
            }
            case Z: {
                return CollisionUtil.collideZ(this, box, maxDist);
            }
        }
        throw new RuntimeException("Unknown axis: " + String.valueOf(axis));
    }

    protected double collideX(AxisCycle axisCycle, AABB box, double maxDist) {
        block11: {
            int n;
            int l;
            double e;
            Direction.Axis axis;
            AxisCycle axisCycle2;
            block10: {
                if (this.isEmpty()) {
                    return maxDist;
                }
                if (Math.abs(maxDist) < 1.0E-7) {
                    return 0.0;
                }
                axisCycle2 = axisCycle.inverse();
                axis = axisCycle2.cycle(Direction.Axis.X);
                Direction.Axis axis2 = axisCycle2.cycle(Direction.Axis.Y);
                Direction.Axis axis3 = axisCycle2.cycle(Direction.Axis.Z);
                double d = box.max(axis);
                e = box.min(axis);
                int i = this.findIndex(axis, e + 1.0E-7);
                int j = this.findIndex(axis, d - 1.0E-7);
                int k = Math.max(0, this.findIndex(axis2, box.min(axis2) + 1.0E-7));
                l = Math.min(this.shape.getSize(axis2), this.findIndex(axis2, box.max(axis2) - 1.0E-7) + 1);
                int m = Math.max(0, this.findIndex(axis3, box.min(axis3) + 1.0E-7));
                n = Math.min(this.shape.getSize(axis3), this.findIndex(axis3, box.max(axis3) - 1.0E-7) + 1);
                int o = this.shape.getSize(axis);
                if (!(maxDist > 0.0)) break block10;
                for (int p = j + 1; p < o; ++p) {
                    for (int q = k; q < l; ++q) {
                        for (int r = m; r < n; ++r) {
                            if (!this.shape.isFullWide(axisCycle2, p, q, r)) continue;
                            double f = this.get(axis, p) - d;
                            if (f >= -1.0E-7) {
                                maxDist = Math.min(maxDist, f);
                            }
                            return maxDist;
                        }
                    }
                }
                break block11;
            }
            if (!(maxDist < 0.0)) break block11;
            for (int s = i - 1; s >= 0; --s) {
                for (int t = k; t < l; ++t) {
                    for (int u = m; u < n; ++u) {
                        if (!this.shape.isFullWide(axisCycle2, s, t, u)) continue;
                        double g = this.get(axis, s + 1) - e;
                        if (g <= 1.0E-7) {
                            maxDist = Math.max(maxDist, g);
                        }
                        return maxDist;
                    }
                }
            }
        }
        return maxDist;
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.bounds()) + "]";
    }
}

