/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickAccess;

public class LevelTicks<T>
implements LevelTickAccess<T> {
    private static final Comparator<LevelChunkTicks<?>> CONTAINER_DRAIN_ORDER = (a, b) -> ScheduledTick.INTRA_TICK_DRAIN_ORDER.compare(a.peek(), b.peek());
    private final LongPredicate tickCheck;
    private final Supplier<ProfilerFiller> profiler;
    private final Long2ObjectMap<LevelChunkTicks<T>> allContainers = new Long2ObjectOpenHashMap();
    private final Long2LongMap nextTickForContainer = (Long2LongMap)Util.make(new Long2LongOpenHashMap(), map -> map.defaultReturnValue(Long.MAX_VALUE));
    private final Queue<LevelChunkTicks<T>> containersToTick = new PriorityQueue(CONTAINER_DRAIN_ORDER);
    private final Queue<ScheduledTick<T>> toRunThisTick = new ArrayDeque<ScheduledTick<T>>();
    private final List<ScheduledTick<T>> alreadyRunThisTick = new ArrayList<ScheduledTick<T>>();
    private final Set<ScheduledTick<?>> toRunThisTickSet = new ObjectOpenCustomHashSet(ScheduledTick.UNIQUE_TICK_HASH);
    private final BiConsumer<LevelChunkTicks<T>, ScheduledTick<T>> chunkScheduleUpdater = (chunkTickScheduler, tick) -> {
        if (tick.equals(chunkTickScheduler.peek())) {
            this.updateContainerScheduling((ScheduledTick<T>)tick);
        }
    };

    public LevelTicks(LongPredicate tickingFutureReadyPredicate, Supplier<ProfilerFiller> profilerGetter) {
        this.tickCheck = tickingFutureReadyPredicate;
        this.profiler = profilerGetter;
    }

    public void addContainer(ChunkPos pos, LevelChunkTicks<T> scheduler) {
        long l = pos.toLong();
        this.allContainers.put(l, scheduler);
        ScheduledTick<T> scheduledTick = scheduler.peek();
        if (scheduledTick != null) {
            this.nextTickForContainer.put(l, scheduledTick.triggerTick());
        }
        scheduler.setOnTickAdded(this.chunkScheduleUpdater);
    }

    public void removeContainer(ChunkPos pos) {
        long l = pos.toLong();
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.allContainers.remove(l);
        this.nextTickForContainer.remove(l);
        if (levelChunkTicks != null) {
            levelChunkTicks.setOnTickAdded(null);
        }
    }

    @Override
    public void schedule(ScheduledTick<T> orderedTick) {
        long l = ChunkPos.asLong(orderedTick.pos());
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.allContainers.get(l);
        if (levelChunkTicks == null) {
            Util.pauseInIde(new IllegalStateException("Trying to schedule tick in not loaded position " + String.valueOf(orderedTick.pos())));
        } else {
            levelChunkTicks.schedule(orderedTick);
        }
    }

    public void tick(long time, int maxTicks, BiConsumer<BlockPos, T> ticker) {
        this.collectTicks(time, maxTicks, null);
        this.runCollectedTicks(ticker);
        this.cleanupAfterTick();
    }

    private void collectTicks(long time, int maxTicks, ProfilerFiller profiler) {
        this.sortContainersToTick(time);
        this.drainContainers(time, maxTicks);
        this.rescheduleLeftoverContainers();
    }

    private void sortContainersToTick(long time) {
        ObjectIterator objectIterator = Long2LongMaps.fastIterator((Long2LongMap)this.nextTickForContainer);
        while (objectIterator.hasNext()) {
            Long2LongMap.Entry entry = (Long2LongMap.Entry)objectIterator.next();
            long l = entry.getLongKey();
            long m = entry.getLongValue();
            if (m > time) continue;
            LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.allContainers.get(l);
            if (levelChunkTicks == null) {
                objectIterator.remove();
                continue;
            }
            ScheduledTick scheduledTick = levelChunkTicks.peek();
            if (scheduledTick == null) {
                objectIterator.remove();
                continue;
            }
            if (scheduledTick.triggerTick() > time) {
                entry.setValue(scheduledTick.triggerTick());
                continue;
            }
            if (!this.tickCheck.test(l)) continue;
            objectIterator.remove();
            this.containersToTick.add(levelChunkTicks);
        }
    }

    private void drainContainers(long time, int maxTicks) {
        LevelChunkTicks<T> levelChunkTicks;
        while (this.canScheduleMoreTicks(maxTicks) && (levelChunkTicks = this.containersToTick.poll()) != null) {
            ScheduledTick<T> scheduledTick = levelChunkTicks.poll();
            this.scheduleForThisTick(scheduledTick);
            this.drainFromCurrentContainer(this.containersToTick, levelChunkTicks, time, maxTicks);
            ScheduledTick<T> scheduledTick2 = levelChunkTicks.peek();
            if (scheduledTick2 == null) continue;
            if (scheduledTick2.triggerTick() <= time && this.canScheduleMoreTicks(maxTicks)) {
                this.containersToTick.add(levelChunkTicks);
                continue;
            }
            this.updateContainerScheduling(scheduledTick2);
        }
    }

    private void rescheduleLeftoverContainers() {
        for (LevelChunkTicks levelChunkTicks : this.containersToTick) {
            this.updateContainerScheduling(levelChunkTicks.peek());
        }
    }

    private void updateContainerScheduling(ScheduledTick<T> tick) {
        this.nextTickForContainer.put(ChunkPos.asLong(tick.pos()), tick.triggerTick());
    }

    private void drainFromCurrentContainer(Queue<LevelChunkTicks<T>> tickableChunkTickSchedulers, LevelChunkTicks<T> chunkTickScheduler, long tick, int maxTicks) {
        if (this.canScheduleMoreTicks(maxTicks)) {
            ScheduledTick<T> scheduledTick2;
            ScheduledTick<T> scheduledTick;
            LevelChunkTicks<T> levelChunkTicks = tickableChunkTickSchedulers.peek();
            ScheduledTick<T> scheduledTick3 = scheduledTick = levelChunkTicks != null ? levelChunkTicks.peek() : null;
            while (this.canScheduleMoreTicks(maxTicks) && (scheduledTick2 = chunkTickScheduler.peek()) != null && scheduledTick2.triggerTick() <= tick && (scheduledTick == null || ScheduledTick.INTRA_TICK_DRAIN_ORDER.compare(scheduledTick2, scheduledTick) <= 0)) {
                chunkTickScheduler.poll();
                this.scheduleForThisTick(scheduledTick2);
            }
        }
    }

    private void scheduleForThisTick(ScheduledTick<T> tick) {
        this.toRunThisTick.add(tick);
    }

    private boolean canScheduleMoreTicks(int maxTicks) {
        return this.toRunThisTick.size() < maxTicks;
    }

    private void runCollectedTicks(BiConsumer<BlockPos, T> ticker) {
        while (!this.toRunThisTick.isEmpty()) {
            ScheduledTick<T> scheduledTick = this.toRunThisTick.poll();
            if (!this.toRunThisTickSet.isEmpty()) {
                this.toRunThisTickSet.remove(scheduledTick);
            }
            this.alreadyRunThisTick.add(scheduledTick);
            ticker.accept(scheduledTick.pos(), (BlockPos)scheduledTick.type());
        }
    }

    private void cleanupAfterTick() {
        this.toRunThisTick.clear();
        this.containersToTick.clear();
        this.alreadyRunThisTick.clear();
        this.toRunThisTickSet.clear();
    }

    @Override
    public boolean hasScheduledTick(BlockPos pos, T type) {
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.allContainers.get(ChunkPos.asLong(pos));
        return levelChunkTicks != null && levelChunkTicks.hasScheduledTick(pos, type);
    }

    @Override
    public boolean willTickThisTick(BlockPos pos, T type) {
        this.calculateTickSetIfNeeded();
        return this.toRunThisTickSet.contains(ScheduledTick.probe(type, pos));
    }

    private void calculateTickSetIfNeeded() {
        if (this.toRunThisTickSet.isEmpty() && !this.toRunThisTick.isEmpty()) {
            this.toRunThisTickSet.addAll(this.toRunThisTick);
        }
    }

    private void forContainersInArea(BoundingBox box, PosAndContainerConsumer<T> visitor) {
        int i = SectionPos.posToSectionCoord(box.minX());
        int j = SectionPos.posToSectionCoord(box.minZ());
        int k = SectionPos.posToSectionCoord(box.maxX());
        int l = SectionPos.posToSectionCoord(box.maxZ());
        for (int m = i; m <= k; ++m) {
            for (int n = j; n <= l; ++n) {
                long o = ChunkPos.asLong(m, n);
                LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.allContainers.get(o);
                if (levelChunkTicks == null) continue;
                visitor.accept(o, levelChunkTicks);
            }
        }
    }

    public void clearArea(BoundingBox box) {
        Predicate<ScheduledTick> predicate = tick -> box.isInside(tick.pos());
        this.forContainersInArea(box, (chunkPos, chunkTickScheduler) -> {
            ScheduledTick scheduledTick = chunkTickScheduler.peek();
            chunkTickScheduler.removeIf(predicate);
            ScheduledTick scheduledTick2 = chunkTickScheduler.peek();
            if (scheduledTick2 != scheduledTick) {
                if (scheduledTick2 != null) {
                    this.updateContainerScheduling(scheduledTick2);
                } else {
                    this.nextTickForContainer.remove(chunkPos);
                }
            }
        });
        this.alreadyRunThisTick.removeIf(predicate);
        this.toRunThisTick.removeIf(predicate);
    }

    public void copyArea(BoundingBox box, Vec3i offset) {
        this.copyAreaFrom(this, box, offset);
    }

    public void copyAreaFrom(LevelTicks<T> scheduler, BoundingBox box, Vec3i offset) {
        ArrayList list = new ArrayList();
        Predicate<ScheduledTick> predicate = tick -> box.isInside(tick.pos());
        scheduler.alreadyRunThisTick.stream().filter(predicate).forEach(list::add);
        scheduler.toRunThisTick.stream().filter(predicate).forEach(list::add);
        scheduler.forContainersInArea(box, (chunkPos, chunkTickScheduler) -> chunkTickScheduler.getAll().filter(predicate).forEach(list::add));
        LongSummaryStatistics longSummaryStatistics = list.stream().mapToLong(ScheduledTick::subTickOrder).summaryStatistics();
        long l = longSummaryStatistics.getMin();
        long m = longSummaryStatistics.getMax();
        list.forEach(tick -> this.schedule(new ScheduledTick(tick.type(), tick.pos().offset(offset), tick.triggerTick(), tick.priority(), tick.subTickOrder() - l + m + 1L)));
    }

    @Override
    public int count() {
        return this.allContainers.values().stream().mapToInt(TickAccess::count).sum();
    }

    @FunctionalInterface
    static interface PosAndContainerConsumer<T> {
        public void accept(long var1, LevelChunkTicks<T> var3);
    }
}

