/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Container;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.util.CraftChatMessage;

public abstract class CraftContainer<T extends BaseContainerBlockEntity>
extends CraftBlockEntityState<T>
implements Container {
    public CraftContainer(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftContainer(CraftContainer<T> state, Location location) {
        super(state, location);
    }

    public boolean isLocked() {
        return !((BaseContainerBlockEntity)this.getSnapshot()).lockKey.key().isEmpty();
    }

    public String getLock() {
        return ((BaseContainerBlockEntity)this.getSnapshot()).lockKey.key();
    }

    public void setLock(String key) {
        ((BaseContainerBlockEntity)this.getSnapshot()).lockKey = key == null ? LockCode.NO_LOCK : new LockCode(key);
    }

    public Component customName() {
        BaseContainerBlockEntity be = (BaseContainerBlockEntity)this.getSnapshot();
        return be.hasCustomName() ? PaperAdventure.asAdventure(be.getCustomName()) : null;
    }

    public void customName(Component customName) {
        ((BaseContainerBlockEntity)this.getSnapshot()).name = customName != null ? PaperAdventure.asVanilla(customName) : null;
    }

    public String getCustomName() {
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)this.getSnapshot();
        return container.name != null ? CraftChatMessage.fromComponent(container.getCustomName()) : null;
    }

    public void setCustomName(String name) {
        ((BaseContainerBlockEntity)this.getSnapshot()).name = CraftChatMessage.fromStringOrNull(name);
    }

    @Override
    public void applyTo(T container) {
        super.applyTo(container);
        if (((BaseContainerBlockEntity)this.getSnapshot()).name == null) {
            ((BaseContainerBlockEntity)container).name = null;
        }
    }

    @Override
    public abstract CraftContainer<T> copy();

    @Override
    public abstract CraftContainer<T> copy(Location var1);
}

