/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.commands.FeedbackForwardingSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftMinecartCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.minecart.CommandMinecart;

public class VanillaCommandWrapper
extends BukkitCommand {
    public final CommandNode<CommandSourceStack> vanillaCommand;

    public VanillaCommandWrapper(String name, String description, String usageMessage, List<String> aliases, CommandNode<CommandSourceStack> vanillaCommand) {
        super(name, description, usageMessage, aliases);
        this.vanillaCommand = vanillaCommand;
    }

    Commands commands() {
        return MinecraftServer.getServer().getCommands();
    }

    public VanillaCommandWrapper(Commands dispatcher, CommandNode<CommandSourceStack> vanillaCommand) {
        super(vanillaCommand.getName(), "A Mojang provided command.", vanillaCommand.getUsageText(), Collections.EMPTY_LIST);
        this.vanillaCommand = vanillaCommand;
        this.setPermission(VanillaCommandWrapper.getPermission(vanillaCommand));
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        CommandSourceStack icommandlistener = VanillaCommandWrapper.getListener(sender);
        this.commands().performPrefixedCommand(icommandlistener, this.toDispatcher(args, this.getName()), this.toDispatcher(args, commandLabel));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        CommandSourceStack icommandlistener = VanillaCommandWrapper.getListener(sender);
        ParseResults<CommandSourceStack> parsed = this.commands().getDispatcher().parse(this.toDispatcher(args, this.getName()), icommandlistener);
        ArrayList<String> results = new ArrayList<String>();
        this.commands().getDispatcher().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s -> results.add(s.getText())));
        return results;
    }

    public static CommandSourceStack getListener(CommandSender sender) {
        if (sender instanceof Entity) {
            if (sender instanceof CommandMinecart) {
                return ((CraftMinecartCommand)sender).getHandle().getCommandBlock().createCommandSourceStack();
            }
            return ((CraftEntity)sender).getHandle().createCommandSourceStack();
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((CraftRemoteConsoleCommandSender)sender).getListener().createCommandSourceStack();
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer().createCommandSourceStack();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        if (sender instanceof FeedbackForwardingSender) {
            FeedbackForwardingSender feedback = (FeedbackForwardingSender)sender;
            return feedback.asVanilla();
        }
        throw new IllegalArgumentException("Cannot make " + String.valueOf(sender) + " a vanilla command listener");
    }

    public static String getPermission(CommandNode<CommandSourceStack> vanillaCommand) {
        while (vanillaCommand.getRedirect() != null) {
            vanillaCommand = vanillaCommand.getRedirect();
        }
        String commandName = vanillaCommand.getName();
        if ("pgive".equals(VanillaCommandWrapper.stripDefaultNamespace(commandName))) {
            return "bukkit.command.paper.pgive";
        }
        return "minecraft.command." + VanillaCommandWrapper.stripDefaultNamespace(commandName);
    }

    private static String stripDefaultNamespace(String maybeNamespaced) {
        String prefix = "minecraft:";
        if (maybeNamespaced.startsWith("minecraft:")) {
            return maybeNamespaced.substring("minecraft:".length());
        }
        return maybeNamespaced;
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }

    public boolean canBeOverriden() {
        return true;
    }

    public boolean isRegistered() {
        return true;
    }
}

