/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, net.minecraft.world.entity.npc.Villager entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.npc.Villager getHandle() {
        return (net.minecraft.world.entity.npc.Villager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().releaseAllPois();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftToBukkit(this.getHandle().getVillagerData().getProfession());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().setProfession(CraftProfession.bukkitToMinecraft(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftToBukkit(this.getHandle().getVillagerData().getType());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().setType(CraftType.bukkitToMinecraft(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().getVillagerData().getLevel();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().setLevel(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().getVillagerXp();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().setVillagerXp(experience);
    }

    public boolean increaseLevel(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Level earned must be positive");
        int supposedFinalLevel = this.getVillagerLevel() + amount;
        Preconditions.checkArgument((1 <= supposedFinalLevel && supposedFinalLevel <= 5 ? 1 : 0) != 0, (Object)"Final level reached after the donation (%d) must be between [%d, %d]".formatted(supposedFinalLevel, 1, 5));
        Int2ObjectMap<VillagerTrades.ItemListing[]> trades = VillagerTrades.TRADES.get(this.getHandle().getVillagerData().getProfession());
        if (trades == null || trades.isEmpty()) {
            this.getHandle().setVillagerData(this.getHandle().getVillagerData().setLevel(supposedFinalLevel));
            return false;
        }
        while (amount > 0) {
            this.getHandle().increaseMerchantCareer();
            --amount;
        }
        return true;
    }

    public boolean addTrades(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Number of trades unlocked must be positive");
        return this.getHandle().updateTrades(amount);
    }

    public int getRestocksToday() {
        return this.getHandle().numberOfRestocksToday;
    }

    public void setRestocksToday(int restocksToday) {
        this.getHandle().numberOfRestocksToday = restocksToday;
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPos position = CraftLocation.toBlockPosition(location);
        BlockState iblockdata = this.getHandle().level().getBlockState(position);
        if (!(iblockdata.getBlock() instanceof BedBlock)) {
            return false;
        }
        this.getHandle().startSleeping(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().stopSleeping();
    }

    public void shakeHead() {
        this.getHandle().setUnhappy();
    }

    public ZombieVillager zombify() {
        net.minecraft.world.entity.monster.ZombieVillager entityzombievillager = Zombie.zombifyVillager(this.getHandle().level().getMinecraftWorld(), this.getHandle(), this.getHandle().blockPosition(), this.isSilent(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public Reputation getReputation(UUID uniqueId) {
        GossipContainer.EntityGossips rep = this.getHandle().getGossips().gossips.get(uniqueId);
        if (rep == null) {
            return new Reputation(new EnumMap(ReputationType.class));
        }
        return rep.getPaperReputation();
    }

    public Map<UUID, Reputation> getReputations() {
        return this.getHandle().getGossips().gossips.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((GossipContainer.EntityGossips)entry.getValue()).getPaperReputation()));
    }

    public void setReputation(UUID uniqueId, Reputation reputation) {
        GossipContainer.EntityGossips nmsReputation = this.getHandle().getGossips().gossips.computeIfAbsent(uniqueId, key -> new GossipContainer.EntityGossips());
        nmsReputation.assignFromPaperReputation(reputation);
    }

    public void setReputations(Map<UUID, Reputation> reputations) {
        for (Map.Entry<UUID, Reputation> entry : reputations.entrySet()) {
            this.setReputation(entry.getKey(), entry.getValue());
        }
    }

    public void clearReputations() {
        this.getHandle().getGossips().gossips.clear();
    }

    public boolean isLobotomized() {
        return this.getHandle().isLobotomized();
    }

    public static class CraftProfession {
        public static Villager.Profession minecraftToBukkit(VillagerProfession minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_PROFESSION);
            Villager.Profession bukkit = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().location()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static VillagerProfession bukkitToMinecraft(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (VillagerProfession)CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_PROFESSION).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }

    public static class CraftType {
        public static Villager.Type minecraftToBukkit(VillagerType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_TYPE);
            Villager.Type bukkit = (Villager.Type)Registry.VILLAGER_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().location()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static VillagerType bukkitToMinecraft(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (VillagerType)CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_TYPE).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }
}

