/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.Witch;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftRaider;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class CraftWitch
extends CraftRaider
implements org.bukkit.entity.Witch,
CraftRangedEntity<Witch> {
    public CraftWitch(CraftServer server, Witch entity) {
        super(server, entity);
    }

    @Override
    public Witch getHandle() {
        return (Witch)this.entity;
    }

    @Override
    public String toString() {
        return "CraftWitch";
    }

    public boolean isDrinkingPotion() {
        return this.getHandle().isDrinkingPotion();
    }

    public int getPotionUseTimeLeft() {
        return this.getHandle().usingTime;
    }

    public void setPotionUseTimeLeft(int ticks) {
        this.getHandle().usingTime = ticks;
    }

    public ItemStack getDrinkingPotion() {
        return CraftItemStack.asCraftMirror(this.getHandle().getMainHandItem());
    }

    public void setDrinkingPotion(ItemStack potion) {
        Preconditions.checkArgument((potion == null || potion.getType().isEmpty() || potion.getType() == Material.POTION ? 1 : 0) != 0, (Object)"must be potion, air, or null");
        this.getHandle().setDrinkingPotion(CraftItemStack.asNMSCopy(potion));
    }
}

